/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.multipart.reply.multipart.reply.body;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Desc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.multipart.reply.multipart.reply.body.MultipartReplyDesc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartReplyDescBuilder
implements Builder<MultipartReplyDesc> {
    private String _description;
    private String _hardware;
    private String _manufacturer;
    private String _serialNumber;
    private String _software;
    Map<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>> augmentation = Collections.emptyMap();

    public MultipartReplyDescBuilder() {
    }

    public MultipartReplyDescBuilder(Desc arg) {
        this._manufacturer = arg.getManufacturer();
        this._hardware = arg.getHardware();
        this._software = arg.getSoftware();
        this._serialNumber = arg.getSerialNumber();
        this._description = arg.getDescription();
    }

    public MultipartReplyDescBuilder(MultipartReplyDesc base) {
        AugmentationHolder casted;
        this._description = base.getDescription();
        this._hardware = base.getHardware();
        this._manufacturer = base.getManufacturer();
        this._serialNumber = base.getSerialNumber();
        this._software = base.getSoftware();
        if (base instanceof MultipartReplyDescImpl) {
            MultipartReplyDescImpl impl = (MultipartReplyDescImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Desc) {
            this._manufacturer = ((Desc)arg).getManufacturer();
            this._hardware = ((Desc)arg).getHardware();
            this._software = ((Desc)arg).getSoftware();
            this._serialNumber = ((Desc)arg).getSerialNumber();
            this._description = ((Desc)arg).getDescription();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Desc] \nbut was: " + arg);
        }
    }

    public String getDescription() {
        return this._description;
    }

    public String getHardware() {
        return this._hardware;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }

    public String getSoftware() {
        return this._software;
    }

    public <E extends Augmentation<MultipartReplyDesc>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MultipartReplyDescBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public MultipartReplyDescBuilder setHardware(String value) {
        this._hardware = value;
        return this;
    }

    public MultipartReplyDescBuilder setManufacturer(String value) {
        this._manufacturer = value;
        return this;
    }

    public MultipartReplyDescBuilder setSerialNumber(String value) {
        this._serialNumber = value;
        return this;
    }

    public MultipartReplyDescBuilder setSoftware(String value) {
        this._software = value;
        return this;
    }

    public MultipartReplyDescBuilder addAugmentation(Class<? extends Augmentation<MultipartReplyDesc>> augmentationType, Augmentation<MultipartReplyDesc> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartReplyDescBuilder removeAugmentation(Class<? extends Augmentation<MultipartReplyDesc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MultipartReplyDesc build() {
        return new MultipartReplyDescImpl(this);
    }

    private static final class MultipartReplyDescImpl
    implements MultipartReplyDesc {
        private final String _description;
        private final String _hardware;
        private final String _manufacturer;
        private final String _serialNumber;
        private final String _software;
        private Map<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MultipartReplyDesc> getImplementedInterface() {
            return MultipartReplyDesc.class;
        }

        private MultipartReplyDescImpl(MultipartReplyDescBuilder base) {
            this._description = base.getDescription();
            this._hardware = base.getHardware();
            this._manufacturer = base.getManufacturer();
            this._serialNumber = base.getSerialNumber();
            this._software = base.getSoftware();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>>(base.augmentation);
                }
            }
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getHardware() {
            return this._hardware;
        }

        @Override
        public String getManufacturer() {
            return this._manufacturer;
        }

        @Override
        public String getSerialNumber() {
            return this._serialNumber;
        }

        @Override
        public String getSoftware() {
            return this._software;
        }

        public <E extends Augmentation<MultipartReplyDesc>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._hardware);
            result = 31 * result + Objects.hashCode(this._manufacturer);
            result = 31 * result + Objects.hashCode(this._serialNumber);
            result = 31 * result + Objects.hashCode(this._software);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MultipartReplyDesc.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MultipartReplyDesc other = (MultipartReplyDesc)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._hardware, other.getHardware())) {
                return false;
            }
            if (!Objects.equals(this._manufacturer, other.getManufacturer())) {
                return false;
            }
            if (!Objects.equals(this._serialNumber, other.getSerialNumber())) {
                return false;
            }
            if (!Objects.equals(this._software, other.getSoftware())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MultipartReplyDescImpl otherImpl = (MultipartReplyDescImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MultipartReplyDesc>>, Augmentation<MultipartReplyDesc>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "MultipartReplyDesc [";
            StringBuilder builder = new StringBuilder(name);
            if (this._description != null) {
                builder.append("_description=");
                builder.append(this._description);
                builder.append(", ");
            }
            if (this._hardware != null) {
                builder.append("_hardware=");
                builder.append(this._hardware);
                builder.append(", ");
            }
            if (this._manufacturer != null) {
                builder.append("_manufacturer=");
                builder.append(this._manufacturer);
                builder.append(", ");
            }
            if (this._serialNumber != null) {
                builder.append("_serialNumber=");
                builder.append(this._serialNumber);
                builder.append(", ");
            }
            if (this._software != null) {
                builder.append("_software=");
                builder.append(this._software);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

