/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.match.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.match.types.MatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.match.types.MatchTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.SupportType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchTypeBuilder
implements Builder<MatchType> {
    private MatchTypeKey _key;
    private String _match;
    private SupportType _supportState;
    Map<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>> augmentation = Collections.emptyMap();

    public MatchTypeBuilder() {
    }

    public MatchTypeBuilder(Feature arg) {
        this._supportState = arg.getSupportState();
    }

    public MatchTypeBuilder(MatchType base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new MatchTypeKey(base.getMatch());
            this._match = base.getMatch();
        } else {
            this._key = base.getKey();
            this._match = this._key.getMatch();
        }
        this._supportState = base.getSupportState();
        if (base instanceof MatchTypeImpl) {
            MatchTypeImpl impl = (MatchTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Feature) {
            this._supportState = ((Feature)arg).getSupportState();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature] \nbut was: " + arg);
        }
    }

    public MatchTypeKey getKey() {
        return this._key;
    }

    public String getMatch() {
        return this._match;
    }

    public SupportType getSupportState() {
        return this._supportState;
    }

    public <E extends Augmentation<MatchType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchTypeBuilder setKey(MatchTypeKey value) {
        this._key = value;
        return this;
    }

    public MatchTypeBuilder setMatch(String value) {
        this._match = value;
        return this;
    }

    public MatchTypeBuilder setSupportState(SupportType value) {
        this._supportState = value;
        return this;
    }

    public MatchTypeBuilder addAugmentation(Class<? extends Augmentation<MatchType>> augmentationType, Augmentation<MatchType> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchTypeBuilder removeAugmentation(Class<? extends Augmentation<MatchType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MatchType build() {
        return new MatchTypeImpl(this);
    }

    private static final class MatchTypeImpl
    implements MatchType {
        private final MatchTypeKey _key;
        private final String _match;
        private final SupportType _supportState;
        private Map<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MatchType> getImplementedInterface() {
            return MatchType.class;
        }

        private MatchTypeImpl(MatchTypeBuilder base) {
            if (base.getKey() == null) {
                this._key = new MatchTypeKey(base.getMatch());
                this._match = base.getMatch();
            } else {
                this._key = base.getKey();
                this._match = this._key.getMatch();
            }
            this._supportState = base.getSupportState();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>>(base.augmentation);
                }
            }
        }

        @Override
        public MatchTypeKey getKey() {
            return this._key;
        }

        @Override
        public String getMatch() {
            return this._match;
        }

        @Override
        public SupportType getSupportState() {
            return this._supportState;
        }

        public <E extends Augmentation<MatchType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._supportState);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MatchType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MatchType other = (MatchType)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._supportState, other.getSupportState())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MatchTypeImpl otherImpl = (MatchTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "MatchType [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._match != null) {
                builder.append("_match=");
                builder.append(this._match);
                builder.append(", ");
            }
            if (this._supportState != null) {
                builder.append("_supportState=");
                builder.append(this._supportState);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

