/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.actions.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.actions.ActionTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.SupportType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ActionTypeBuilder
implements Builder<ActionType> {
    private String _action;
    private ActionTypeKey _key;
    private SupportType _supportState;
    Map<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> augmentation = Collections.emptyMap();

    public ActionTypeBuilder() {
    }

    public ActionTypeBuilder(Feature arg) {
        this._supportState = arg.getSupportState();
    }

    public ActionTypeBuilder(ActionType base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ActionTypeKey(base.getAction());
            this._action = base.getAction();
        } else {
            this._key = base.getKey();
            this._action = this._key.getAction();
        }
        this._supportState = base.getSupportState();
        if (base instanceof ActionTypeImpl) {
            ActionTypeImpl impl = (ActionTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Feature) {
            this._supportState = ((Feature)arg).getSupportState();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature] \nbut was: " + arg);
        }
    }

    public String getAction() {
        return this._action;
    }

    public ActionTypeKey getKey() {
        return this._key;
    }

    public SupportType getSupportState() {
        return this._supportState;
    }

    public <E extends Augmentation<ActionType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ActionTypeBuilder setAction(String value) {
        this._action = value;
        return this;
    }

    public ActionTypeBuilder setKey(ActionTypeKey value) {
        this._key = value;
        return this;
    }

    public ActionTypeBuilder setSupportState(SupportType value) {
        this._supportState = value;
        return this;
    }

    public ActionTypeBuilder addAugmentation(Class<? extends Augmentation<ActionType>> augmentationType, Augmentation<ActionType> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ActionTypeBuilder removeAugmentation(Class<? extends Augmentation<ActionType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ActionType build() {
        return new ActionTypeImpl(this);
    }

    private static final class ActionTypeImpl
    implements ActionType {
        private final String _action;
        private final ActionTypeKey _key;
        private final SupportType _supportState;
        private Map<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ActionType> getImplementedInterface() {
            return ActionType.class;
        }

        private ActionTypeImpl(ActionTypeBuilder base) {
            if (base.getKey() == null) {
                this._key = new ActionTypeKey(base.getAction());
                this._action = base.getAction();
            } else {
                this._key = base.getKey();
                this._action = this._key.getAction();
            }
            this._supportState = base.getSupportState();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAction() {
            return this._action;
        }

        @Override
        public ActionTypeKey getKey() {
            return this._key;
        }

        @Override
        public SupportType getSupportState() {
            return this._supportState;
        }

        public <E extends Augmentation<ActionType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._action);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._supportState);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ActionType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ActionType other = (ActionType)obj;
            if (!Objects.equals(this._action, other.getAction())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._supportState, other.getSupportState())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ActionTypeImpl otherImpl = (ActionTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ActionType>>, Augmentation<ActionType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ActionType [";
            StringBuilder builder = new StringBuilder(name);
            if (this._action != null) {
                builder.append("_action=");
                builder.append(this._action);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._supportState != null) {
                builder.append("_supportState=");
                builder.append(this._supportState);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

