/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SupportedInstructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.instructions.InstructionType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportedInstructionsBuilder
implements Builder<SupportedInstructions> {
    private List<InstructionType> _instructionType;
    Map<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>> augmentation = Collections.emptyMap();

    public SupportedInstructionsBuilder() {
    }

    public SupportedInstructionsBuilder(SupportedInstructions base) {
        AugmentationHolder casted;
        this._instructionType = base.getInstructionType();
        if (base instanceof SupportedInstructionsImpl) {
            SupportedInstructionsImpl impl = (SupportedInstructionsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>>(casted.augmentations());
        }
    }

    public List<InstructionType> getInstructionType() {
        return this._instructionType;
    }

    public <E extends Augmentation<SupportedInstructions>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SupportedInstructionsBuilder setInstructionType(List<InstructionType> value) {
        this._instructionType = value;
        return this;
    }

    public SupportedInstructionsBuilder addAugmentation(Class<? extends Augmentation<SupportedInstructions>> augmentationType, Augmentation<SupportedInstructions> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SupportedInstructionsBuilder removeAugmentation(Class<? extends Augmentation<SupportedInstructions>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SupportedInstructions build() {
        return new SupportedInstructionsImpl(this);
    }

    private static final class SupportedInstructionsImpl
    implements SupportedInstructions {
        private final List<InstructionType> _instructionType;
        private Map<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SupportedInstructions> getImplementedInterface() {
            return SupportedInstructions.class;
        }

        private SupportedInstructionsImpl(SupportedInstructionsBuilder base) {
            this._instructionType = base.getInstructionType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>>(base.augmentation);
                }
            }
        }

        @Override
        public List<InstructionType> getInstructionType() {
            return this._instructionType;
        }

        public <E extends Augmentation<SupportedInstructions>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._instructionType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportedInstructions.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportedInstructions other = (SupportedInstructions)obj;
            if (!Objects.equals(this._instructionType, other.getInstructionType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportedInstructionsImpl otherImpl = (SupportedInstructionsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SupportedInstructions>>, Augmentation<SupportedInstructions>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SupportedInstructions [";
            StringBuilder builder = new StringBuilder(name);
            if (this._instructionType != null) {
                builder.append("_instructionType=");
                builder.append(this._instructionType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

