/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum ErrorType {
    HelloFailed(0, "hello-failed"),
    BadRequest(1, "bad-request"),
    BadAction(2, "bad-action"),
    BadInstruction(3, "bad-instruction"),
    BadMatch(4, "bad-match"),
    FlowModFailed(5, "flow-mod-failed"),
    GroupModFailed(6, "group-mod-failed"),
    PortModFailed(7, "port-mod-failed"),
    TableModFailed(8, "table-mod-failed"),
    QueueOpFailed(9, "queue-op-failed"),
    SwitchConfigFailed(10, "switch-config-failed"),
    RoleRequestFailed(11, "role-request-failed"),
    MeterModFailed(12, "meter-mod-failed"),
    TableFeaturesFailed(13, "table-features-failed"),
    Experimenter(65535, "experimenter");

    String name;
    int value;
    private static final Map<Integer, ErrorType> VALUE_MAP;

    private ErrorType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static ErrorType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (ErrorType enumItem : ErrorType.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

