/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.output;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.output.BatchFailure;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.output.BatchFailureKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.output.batch.failure.BatchItemIdChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BatchFailureBuilder
implements Builder<BatchFailure> {
    private BatchItemIdChoice _batchItemIdChoice;
    private Integer _batchOrder;
    private BatchFailureKey _key;
    Map<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>> augmentation = Collections.emptyMap();

    public BatchFailureBuilder() {
    }

    public BatchFailureBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public BatchFailureBuilder(BatchFailure base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BatchFailureKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._batchItemIdChoice = base.getBatchItemIdChoice();
        if (base instanceof BatchFailureImpl) {
            BatchFailureImpl impl = (BatchFailureImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping] \nbut was: " + arg);
        }
    }

    public BatchItemIdChoice getBatchItemIdChoice() {
        return this._batchItemIdChoice;
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public BatchFailureKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<BatchFailure>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BatchFailureBuilder setBatchItemIdChoice(BatchItemIdChoice value) {
        this._batchItemIdChoice = value;
        return this;
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public BatchFailureBuilder setBatchOrder(Integer value) {
        if (value != null) {
            BatchFailureBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public BatchFailureBuilder setKey(BatchFailureKey value) {
        this._key = value;
        return this;
    }

    public BatchFailureBuilder addAugmentation(Class<? extends Augmentation<BatchFailure>> augmentationType, Augmentation<BatchFailure> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BatchFailureBuilder removeAugmentation(Class<? extends Augmentation<BatchFailure>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BatchFailure build() {
        return new BatchFailureImpl(this);
    }

    private static final class BatchFailureImpl
    implements BatchFailure {
        private final BatchItemIdChoice _batchItemIdChoice;
        private final Integer _batchOrder;
        private final BatchFailureKey _key;
        private Map<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BatchFailure> getImplementedInterface() {
            return BatchFailure.class;
        }

        private BatchFailureImpl(BatchFailureBuilder base) {
            if (base.getKey() == null) {
                this._key = new BatchFailureKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._batchItemIdChoice = base.getBatchItemIdChoice();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>>(base.augmentation);
                }
            }
        }

        @Override
        public BatchItemIdChoice getBatchItemIdChoice() {
            return this._batchItemIdChoice;
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        @Override
        public BatchFailureKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<BatchFailure>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchItemIdChoice);
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BatchFailure.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BatchFailure other = (BatchFailure)obj;
            if (!Objects.equals(this._batchItemIdChoice, other.getBatchItemIdChoice())) {
                return false;
            }
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BatchFailureImpl otherImpl = (BatchFailureImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BatchFailure>>, Augmentation<BatchFailure>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BatchFailure [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchItemIdChoice != null) {
                builder.append("_batchItemIdChoice=");
                builder.append(this._batchItemIdChoice);
                builder.append(", ");
            }
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

