/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.meter._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.meter._case.FlatBatchUpdateMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.meter._case.FlatBatchUpdateMeterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.BatchMeterInputUpdateGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.batch.meter.input.update.grouping.OriginalBatchedMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.batch.meter.input.update.grouping.UpdatedBatchedMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlatBatchUpdateMeterBuilder
implements Builder<FlatBatchUpdateMeter> {
    private Integer _batchOrder;
    private FlatBatchUpdateMeterKey _key;
    private OriginalBatchedMeter _originalBatchedMeter;
    private UpdatedBatchedMeter _updatedBatchedMeter;
    Map<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>> augmentation = Collections.emptyMap();

    public FlatBatchUpdateMeterBuilder() {
    }

    public FlatBatchUpdateMeterBuilder(BatchMeterInputUpdateGrouping arg) {
        this._originalBatchedMeter = arg.getOriginalBatchedMeter();
        this._updatedBatchedMeter = arg.getUpdatedBatchedMeter();
    }

    public FlatBatchUpdateMeterBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public FlatBatchUpdateMeterBuilder(FlatBatchUpdateMeter base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new FlatBatchUpdateMeterKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._originalBatchedMeter = base.getOriginalBatchedMeter();
        this._updatedBatchedMeter = base.getUpdatedBatchedMeter();
        if (base instanceof FlatBatchUpdateMeterImpl) {
            FlatBatchUpdateMeterImpl impl = (FlatBatchUpdateMeterImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (arg instanceof BatchMeterInputUpdateGrouping) {
            this._originalBatchedMeter = ((BatchMeterInputUpdateGrouping)arg).getOriginalBatchedMeter();
            this._updatedBatchedMeter = ((BatchMeterInputUpdateGrouping)arg).getUpdatedBatchedMeter();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.BatchMeterInputUpdateGrouping] \nbut was: " + arg);
        }
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public FlatBatchUpdateMeterKey getKey() {
        return this._key;
    }

    public OriginalBatchedMeter getOriginalBatchedMeter() {
        return this._originalBatchedMeter;
    }

    public UpdatedBatchedMeter getUpdatedBatchedMeter() {
        return this._updatedBatchedMeter;
    }

    public <E extends Augmentation<FlatBatchUpdateMeter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlatBatchUpdateMeterBuilder setBatchOrder(Integer value) {
        if (value != null) {
            FlatBatchUpdateMeterBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public FlatBatchUpdateMeterBuilder setKey(FlatBatchUpdateMeterKey value) {
        this._key = value;
        return this;
    }

    public FlatBatchUpdateMeterBuilder setOriginalBatchedMeter(OriginalBatchedMeter value) {
        this._originalBatchedMeter = value;
        return this;
    }

    public FlatBatchUpdateMeterBuilder setUpdatedBatchedMeter(UpdatedBatchedMeter value) {
        this._updatedBatchedMeter = value;
        return this;
    }

    public FlatBatchUpdateMeterBuilder addAugmentation(Class<? extends Augmentation<FlatBatchUpdateMeter>> augmentationType, Augmentation<FlatBatchUpdateMeter> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlatBatchUpdateMeterBuilder removeAugmentation(Class<? extends Augmentation<FlatBatchUpdateMeter>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlatBatchUpdateMeter build() {
        return new FlatBatchUpdateMeterImpl(this);
    }

    private static final class FlatBatchUpdateMeterImpl
    implements FlatBatchUpdateMeter {
        private final Integer _batchOrder;
        private final FlatBatchUpdateMeterKey _key;
        private final OriginalBatchedMeter _originalBatchedMeter;
        private final UpdatedBatchedMeter _updatedBatchedMeter;
        private Map<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlatBatchUpdateMeter> getImplementedInterface() {
            return FlatBatchUpdateMeter.class;
        }

        private FlatBatchUpdateMeterImpl(FlatBatchUpdateMeterBuilder base) {
            if (base.getKey() == null) {
                this._key = new FlatBatchUpdateMeterKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._originalBatchedMeter = base.getOriginalBatchedMeter();
            this._updatedBatchedMeter = base.getUpdatedBatchedMeter();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        @Override
        public FlatBatchUpdateMeterKey getKey() {
            return this._key;
        }

        @Override
        public OriginalBatchedMeter getOriginalBatchedMeter() {
            return this._originalBatchedMeter;
        }

        @Override
        public UpdatedBatchedMeter getUpdatedBatchedMeter() {
            return this._updatedBatchedMeter;
        }

        public <E extends Augmentation<FlatBatchUpdateMeter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._originalBatchedMeter);
            result = 31 * result + Objects.hashCode(this._updatedBatchedMeter);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlatBatchUpdateMeter.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlatBatchUpdateMeter other = (FlatBatchUpdateMeter)obj;
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._originalBatchedMeter, other.getOriginalBatchedMeter())) {
                return false;
            }
            if (!Objects.equals(this._updatedBatchedMeter, other.getUpdatedBatchedMeter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlatBatchUpdateMeterImpl otherImpl = (FlatBatchUpdateMeterImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlatBatchUpdateMeter>>, Augmentation<FlatBatchUpdateMeter>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FlatBatchUpdateMeter [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._originalBatchedMeter != null) {
                builder.append("_originalBatchedMeter=");
                builder.append(this._originalBatchedMeter);
                builder.append(", ");
            }
            if (this._updatedBatchedMeter != null) {
                builder.append("_updatedBatchedMeter=");
                builder.append(this._updatedBatchedMeter);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

