/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.group._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.group._case.FlatBatchUpdateGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.group._case.FlatBatchUpdateGroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.BatchGroupInputUpdateGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.batch.group.input.update.grouping.OriginalBatchedGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.batch.group.input.update.grouping.UpdatedBatchedGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlatBatchUpdateGroupBuilder
implements Builder<FlatBatchUpdateGroup> {
    private Integer _batchOrder;
    private FlatBatchUpdateGroupKey _key;
    private OriginalBatchedGroup _originalBatchedGroup;
    private UpdatedBatchedGroup _updatedBatchedGroup;
    Map<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>> augmentation = Collections.emptyMap();

    public FlatBatchUpdateGroupBuilder() {
    }

    public FlatBatchUpdateGroupBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public FlatBatchUpdateGroupBuilder(BatchGroupInputUpdateGrouping arg) {
        this._originalBatchedGroup = arg.getOriginalBatchedGroup();
        this._updatedBatchedGroup = arg.getUpdatedBatchedGroup();
    }

    public FlatBatchUpdateGroupBuilder(FlatBatchUpdateGroup base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new FlatBatchUpdateGroupKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._originalBatchedGroup = base.getOriginalBatchedGroup();
        this._updatedBatchedGroup = base.getUpdatedBatchedGroup();
        if (base instanceof FlatBatchUpdateGroupImpl) {
            FlatBatchUpdateGroupImpl impl = (FlatBatchUpdateGroupImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (arg instanceof BatchGroupInputUpdateGrouping) {
            this._originalBatchedGroup = ((BatchGroupInputUpdateGrouping)arg).getOriginalBatchedGroup();
            this._updatedBatchedGroup = ((BatchGroupInputUpdateGrouping)arg).getUpdatedBatchedGroup();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.BatchGroupInputUpdateGrouping] \nbut was: " + arg);
        }
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public FlatBatchUpdateGroupKey getKey() {
        return this._key;
    }

    public OriginalBatchedGroup getOriginalBatchedGroup() {
        return this._originalBatchedGroup;
    }

    public UpdatedBatchedGroup getUpdatedBatchedGroup() {
        return this._updatedBatchedGroup;
    }

    public <E extends Augmentation<FlatBatchUpdateGroup>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlatBatchUpdateGroupBuilder setBatchOrder(Integer value) {
        if (value != null) {
            FlatBatchUpdateGroupBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public FlatBatchUpdateGroupBuilder setKey(FlatBatchUpdateGroupKey value) {
        this._key = value;
        return this;
    }

    public FlatBatchUpdateGroupBuilder setOriginalBatchedGroup(OriginalBatchedGroup value) {
        this._originalBatchedGroup = value;
        return this;
    }

    public FlatBatchUpdateGroupBuilder setUpdatedBatchedGroup(UpdatedBatchedGroup value) {
        this._updatedBatchedGroup = value;
        return this;
    }

    public FlatBatchUpdateGroupBuilder addAugmentation(Class<? extends Augmentation<FlatBatchUpdateGroup>> augmentationType, Augmentation<FlatBatchUpdateGroup> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlatBatchUpdateGroupBuilder removeAugmentation(Class<? extends Augmentation<FlatBatchUpdateGroup>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlatBatchUpdateGroup build() {
        return new FlatBatchUpdateGroupImpl(this);
    }

    private static final class FlatBatchUpdateGroupImpl
    implements FlatBatchUpdateGroup {
        private final Integer _batchOrder;
        private final FlatBatchUpdateGroupKey _key;
        private final OriginalBatchedGroup _originalBatchedGroup;
        private final UpdatedBatchedGroup _updatedBatchedGroup;
        private Map<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlatBatchUpdateGroup> getImplementedInterface() {
            return FlatBatchUpdateGroup.class;
        }

        private FlatBatchUpdateGroupImpl(FlatBatchUpdateGroupBuilder base) {
            if (base.getKey() == null) {
                this._key = new FlatBatchUpdateGroupKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._originalBatchedGroup = base.getOriginalBatchedGroup();
            this._updatedBatchedGroup = base.getUpdatedBatchedGroup();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        @Override
        public FlatBatchUpdateGroupKey getKey() {
            return this._key;
        }

        @Override
        public OriginalBatchedGroup getOriginalBatchedGroup() {
            return this._originalBatchedGroup;
        }

        @Override
        public UpdatedBatchedGroup getUpdatedBatchedGroup() {
            return this._updatedBatchedGroup;
        }

        public <E extends Augmentation<FlatBatchUpdateGroup>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._originalBatchedGroup);
            result = 31 * result + Objects.hashCode(this._updatedBatchedGroup);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlatBatchUpdateGroup.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlatBatchUpdateGroup other = (FlatBatchUpdateGroup)obj;
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._originalBatchedGroup, other.getOriginalBatchedGroup())) {
                return false;
            }
            if (!Objects.equals(this._updatedBatchedGroup, other.getUpdatedBatchedGroup())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlatBatchUpdateGroupImpl otherImpl = (FlatBatchUpdateGroupImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlatBatchUpdateGroup>>, Augmentation<FlatBatchUpdateGroup>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FlatBatchUpdateGroup [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._originalBatchedGroup != null) {
                builder.append("_originalBatchedGroup=");
                builder.append(this._originalBatchedGroup);
                builder.append(", ");
            }
            if (this._updatedBatchedGroup != null) {
                builder.append("_updatedBatchedGroup=");
                builder.append(this._updatedBatchedGroup);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

