/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.flow._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.flow._case.FlatBatchUpdateFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.update.flow._case.FlatBatchUpdateFlowKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowIdGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowInputUpdateGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.batch.flow.input.update.grouping.OriginalBatchedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.batch.flow.input.update.grouping.UpdatedBatchedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlatBatchUpdateFlowBuilder
implements Builder<FlatBatchUpdateFlow> {
    private Integer _batchOrder;
    private FlowId _flowId;
    private FlatBatchUpdateFlowKey _key;
    private OriginalBatchedFlow _originalBatchedFlow;
    private UpdatedBatchedFlow _updatedBatchedFlow;
    Map<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>> augmentation = Collections.emptyMap();

    public FlatBatchUpdateFlowBuilder() {
    }

    public FlatBatchUpdateFlowBuilder(BatchFlowInputUpdateGrouping arg) {
        this._originalBatchedFlow = arg.getOriginalBatchedFlow();
        this._updatedBatchedFlow = arg.getUpdatedBatchedFlow();
        this._flowId = arg.getFlowId();
    }

    public FlatBatchUpdateFlowBuilder(BatchFlowIdGrouping arg) {
        this._flowId = arg.getFlowId();
    }

    public FlatBatchUpdateFlowBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public FlatBatchUpdateFlowBuilder(FlatBatchUpdateFlow base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new FlatBatchUpdateFlowKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._flowId = base.getFlowId();
        this._originalBatchedFlow = base.getOriginalBatchedFlow();
        this._updatedBatchedFlow = base.getUpdatedBatchedFlow();
        if (base instanceof FlatBatchUpdateFlowImpl) {
            FlatBatchUpdateFlowImpl impl = (FlatBatchUpdateFlowImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (arg instanceof BatchFlowInputUpdateGrouping) {
            this._originalBatchedFlow = ((BatchFlowInputUpdateGrouping)arg).getOriginalBatchedFlow();
            this._updatedBatchedFlow = ((BatchFlowInputUpdateGrouping)arg).getUpdatedBatchedFlow();
            isValidArg = true;
        }
        if (arg instanceof BatchFlowIdGrouping) {
            this._flowId = ((BatchFlowIdGrouping)arg).getFlowId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowInputUpdateGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowIdGrouping] \nbut was: " + arg);
        }
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public FlowId getFlowId() {
        return this._flowId;
    }

    public FlatBatchUpdateFlowKey getKey() {
        return this._key;
    }

    public OriginalBatchedFlow getOriginalBatchedFlow() {
        return this._originalBatchedFlow;
    }

    public UpdatedBatchedFlow getUpdatedBatchedFlow() {
        return this._updatedBatchedFlow;
    }

    public <E extends Augmentation<FlatBatchUpdateFlow>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlatBatchUpdateFlowBuilder setBatchOrder(Integer value) {
        if (value != null) {
            FlatBatchUpdateFlowBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public FlatBatchUpdateFlowBuilder setFlowId(FlowId value) {
        this._flowId = value;
        return this;
    }

    public FlatBatchUpdateFlowBuilder setKey(FlatBatchUpdateFlowKey value) {
        this._key = value;
        return this;
    }

    public FlatBatchUpdateFlowBuilder setOriginalBatchedFlow(OriginalBatchedFlow value) {
        this._originalBatchedFlow = value;
        return this;
    }

    public FlatBatchUpdateFlowBuilder setUpdatedBatchedFlow(UpdatedBatchedFlow value) {
        this._updatedBatchedFlow = value;
        return this;
    }

    public FlatBatchUpdateFlowBuilder addAugmentation(Class<? extends Augmentation<FlatBatchUpdateFlow>> augmentationType, Augmentation<FlatBatchUpdateFlow> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlatBatchUpdateFlowBuilder removeAugmentation(Class<? extends Augmentation<FlatBatchUpdateFlow>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlatBatchUpdateFlow build() {
        return new FlatBatchUpdateFlowImpl(this);
    }

    private static final class FlatBatchUpdateFlowImpl
    implements FlatBatchUpdateFlow {
        private final Integer _batchOrder;
        private final FlowId _flowId;
        private final FlatBatchUpdateFlowKey _key;
        private final OriginalBatchedFlow _originalBatchedFlow;
        private final UpdatedBatchedFlow _updatedBatchedFlow;
        private Map<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlatBatchUpdateFlow> getImplementedInterface() {
            return FlatBatchUpdateFlow.class;
        }

        private FlatBatchUpdateFlowImpl(FlatBatchUpdateFlowBuilder base) {
            if (base.getKey() == null) {
                this._key = new FlatBatchUpdateFlowKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._flowId = base.getFlowId();
            this._originalBatchedFlow = base.getOriginalBatchedFlow();
            this._updatedBatchedFlow = base.getUpdatedBatchedFlow();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        @Override
        public FlowId getFlowId() {
            return this._flowId;
        }

        @Override
        public FlatBatchUpdateFlowKey getKey() {
            return this._key;
        }

        @Override
        public OriginalBatchedFlow getOriginalBatchedFlow() {
            return this._originalBatchedFlow;
        }

        @Override
        public UpdatedBatchedFlow getUpdatedBatchedFlow() {
            return this._updatedBatchedFlow;
        }

        public <E extends Augmentation<FlatBatchUpdateFlow>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._flowId);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._originalBatchedFlow);
            result = 31 * result + Objects.hashCode(this._updatedBatchedFlow);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlatBatchUpdateFlow.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlatBatchUpdateFlow other = (FlatBatchUpdateFlow)obj;
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._flowId, other.getFlowId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._originalBatchedFlow, other.getOriginalBatchedFlow())) {
                return false;
            }
            if (!Objects.equals(this._updatedBatchedFlow, other.getUpdatedBatchedFlow())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlatBatchUpdateFlowImpl otherImpl = (FlatBatchUpdateFlowImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlatBatchUpdateFlow>>, Augmentation<FlatBatchUpdateFlow>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FlatBatchUpdateFlow [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._flowId != null) {
                builder.append("_flowId=");
                builder.append(this._flowId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._originalBatchedFlow != null) {
                builder.append("_originalBatchedFlow=");
                builder.append(this._originalBatchedFlow);
                builder.append(", ");
            }
            if (this._updatedBatchedFlow != null) {
                builder.append("_updatedBatchedFlow=");
                builder.append(this._updatedBatchedFlow);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

