/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.remove.group._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.remove.group._case.FlatBatchRemoveGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.batch.choice.flat.batch.remove.group._case.FlatBatchRemoveGroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlatBatchRemoveGroupBuilder
implements Builder<FlatBatchRemoveGroup> {
    private Integer _batchOrder;
    private Buckets _buckets;
    private String _containerName;
    private GroupId _groupId;
    private String _groupName;
    private GroupTypes _groupType;
    private FlatBatchRemoveGroupKey _key;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>> augmentation = Collections.emptyMap();

    public FlatBatchRemoveGroupBuilder() {
    }

    public FlatBatchRemoveGroupBuilder(Group arg) {
        this._groupType = arg.getGroupType();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._containerName = arg.getContainerName();
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
    }

    public FlatBatchRemoveGroupBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public FlatBatchRemoveGroupBuilder(FlatBatchRemoveGroup base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new FlatBatchRemoveGroupKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._buckets = base.getBuckets();
        this._containerName = base.getContainerName();
        this._groupId = base.getGroupId();
        this._groupName = base.getGroupName();
        this._groupType = base.getGroupType();
        this._barrier = base.isBarrier();
        if (base instanceof FlatBatchRemoveGroupImpl) {
            FlatBatchRemoveGroupImpl impl = (FlatBatchRemoveGroupImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (arg instanceof Group) {
            this._groupType = ((Group)arg).getGroupType();
            this._groupId = ((Group)arg).getGroupId();
            this._groupName = ((Group)arg).getGroupName();
            this._containerName = ((Group)arg).getContainerName();
            this._barrier = ((Group)arg).isBarrier();
            this._buckets = ((Group)arg).getBuckets();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group] \nbut was: " + arg);
        }
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public GroupTypes getGroupType() {
        return this._groupType;
    }

    public FlatBatchRemoveGroupKey getKey() {
        return this._key;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<FlatBatchRemoveGroup>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public FlatBatchRemoveGroupBuilder setBatchOrder(Integer value) {
        if (value != null) {
            FlatBatchRemoveGroupBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder setGroupName(String value) {
        this._groupName = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder setGroupType(GroupTypes value) {
        this._groupType = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder setKey(FlatBatchRemoveGroupKey value) {
        this._key = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public FlatBatchRemoveGroupBuilder addAugmentation(Class<? extends Augmentation<FlatBatchRemoveGroup>> augmentationType, Augmentation<FlatBatchRemoveGroup> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlatBatchRemoveGroupBuilder removeAugmentation(Class<? extends Augmentation<FlatBatchRemoveGroup>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlatBatchRemoveGroup build() {
        return new FlatBatchRemoveGroupImpl(this);
    }

    private static final class FlatBatchRemoveGroupImpl
    implements FlatBatchRemoveGroup {
        private final Integer _batchOrder;
        private final Buckets _buckets;
        private final String _containerName;
        private final GroupId _groupId;
        private final String _groupName;
        private final GroupTypes _groupType;
        private final FlatBatchRemoveGroupKey _key;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlatBatchRemoveGroup> getImplementedInterface() {
            return FlatBatchRemoveGroup.class;
        }

        private FlatBatchRemoveGroupImpl(FlatBatchRemoveGroupBuilder base) {
            if (base.getKey() == null) {
                this._key = new FlatBatchRemoveGroupKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._buckets = base.getBuckets();
            this._containerName = base.getContainerName();
            this._groupId = base.getGroupId();
            this._groupName = base.getGroupName();
            this._groupType = base.getGroupType();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        public Buckets getBuckets() {
            return this._buckets;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public GroupId getGroupId() {
            return this._groupId;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public GroupTypes getGroupType() {
            return this._groupType;
        }

        @Override
        public FlatBatchRemoveGroupKey getKey() {
            return this._key;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<FlatBatchRemoveGroup>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._buckets);
            result = 31 * result + Objects.hashCode(this._containerName);
            result = 31 * result + Objects.hashCode(this._groupId);
            result = 31 * result + Objects.hashCode(this._groupName);
            result = 31 * result + Objects.hashCode(this._groupType);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._barrier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlatBatchRemoveGroup.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlatBatchRemoveGroup other = (FlatBatchRemoveGroup)obj;
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._buckets, other.getBuckets())) {
                return false;
            }
            if (!Objects.equals(this._containerName, other.getContainerName())) {
                return false;
            }
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (!Objects.equals(this._groupName, other.getGroupName())) {
                return false;
            }
            if (!Objects.equals(this._groupType, other.getGroupType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._barrier, other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlatBatchRemoveGroupImpl otherImpl = (FlatBatchRemoveGroupImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlatBatchRemoveGroup>>, Augmentation<FlatBatchRemoveGroup>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FlatBatchRemoveGroup [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._buckets != null) {
                builder.append("_buckets=");
                builder.append(this._buckets);
                builder.append(", ");
            }
            if (this._containerName != null) {
                builder.append("_containerName=");
                builder.append(this._containerName);
                builder.append(", ");
            }
            if (this._groupId != null) {
                builder.append("_groupId=");
                builder.append(this._groupId);
                builder.append(", ");
            }
            if (this._groupName != null) {
                builder.append("_groupName=");
                builder.append(this._groupName);
                builder.append(", ");
            }
            if (this._groupType != null) {
                builder.append("_groupType=");
                builder.append(this._groupType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._barrier != null) {
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

