/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.Batch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.BatchKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.batch.BatchChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BatchBuilder
implements Builder<Batch> {
    private BatchChoice _batchChoice;
    private Integer _batchOrder;
    private BatchKey _key;
    Map<Class<? extends Augmentation<Batch>>, Augmentation<Batch>> augmentation = Collections.emptyMap();

    public BatchBuilder() {
    }

    public BatchBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public BatchBuilder(Batch base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BatchKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._batchChoice = base.getBatchChoice();
        if (base instanceof BatchImpl) {
            BatchImpl impl = (BatchImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Batch>>, Augmentation<Batch>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Batch>>, Augmentation<Batch>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping] \nbut was: " + arg);
        }
    }

    public BatchChoice getBatchChoice() {
        return this._batchChoice;
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public BatchKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Batch>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BatchBuilder setBatchChoice(BatchChoice value) {
        this._batchChoice = value;
        return this;
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public BatchBuilder setBatchOrder(Integer value) {
        if (value != null) {
            BatchBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public BatchBuilder setKey(BatchKey value) {
        this._key = value;
        return this;
    }

    public BatchBuilder addAugmentation(Class<? extends Augmentation<Batch>> augmentationType, Augmentation<Batch> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Batch>>, Augmentation<Batch>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BatchBuilder removeAugmentation(Class<? extends Augmentation<Batch>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Batch build() {
        return new BatchImpl(this);
    }

    private static final class BatchImpl
    implements Batch {
        private final BatchChoice _batchChoice;
        private final Integer _batchOrder;
        private final BatchKey _key;
        private Map<Class<? extends Augmentation<Batch>>, Augmentation<Batch>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Batch> getImplementedInterface() {
            return Batch.class;
        }

        private BatchImpl(BatchBuilder base) {
            if (base.getKey() == null) {
                this._key = new BatchKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._batchChoice = base.getBatchChoice();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Batch>>, Augmentation<Batch>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Batch>>, Augmentation<Batch>>(base.augmentation);
                }
            }
        }

        @Override
        public BatchChoice getBatchChoice() {
            return this._batchChoice;
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        @Override
        public BatchKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Batch>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchChoice);
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Batch.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Batch other = (Batch)obj;
            if (!Objects.equals(this._batchChoice, other.getBatchChoice())) {
                return false;
            }
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BatchImpl otherImpl = (BatchImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Batch>>, Augmentation<Batch>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Batch [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchChoice != null) {
                builder.append("_batchChoice=");
                builder.append(this._batchChoice);
                builder.append(", ");
            }
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

