/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.ProcessFlatBatchInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flat.batch.service.rev160321.process.flat.batch.input.Batch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ProcessFlatBatchInputBuilder
implements Builder<ProcessFlatBatchInput> {
    private List<Batch> _batch;
    private NodeRef _node;
    private Boolean _exitOnFirstError;
    Map<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>> augmentation = Collections.emptyMap();

    public ProcessFlatBatchInputBuilder() {
    }

    public ProcessFlatBatchInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public ProcessFlatBatchInputBuilder(ProcessFlatBatchInput base) {
        AugmentationHolder casted;
        this._batch = base.getBatch();
        this._node = base.getNode();
        this._exitOnFirstError = base.isExitOnFirstError();
        if (base instanceof ProcessFlatBatchInputImpl) {
            ProcessFlatBatchInputImpl impl = (ProcessFlatBatchInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public List<Batch> getBatch() {
        return this._batch;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Boolean isExitOnFirstError() {
        return this._exitOnFirstError;
    }

    public <E extends Augmentation<ProcessFlatBatchInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ProcessFlatBatchInputBuilder setBatch(List<Batch> value) {
        this._batch = value;
        return this;
    }

    public ProcessFlatBatchInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public ProcessFlatBatchInputBuilder setExitOnFirstError(Boolean value) {
        this._exitOnFirstError = value;
        return this;
    }

    public ProcessFlatBatchInputBuilder addAugmentation(Class<? extends Augmentation<ProcessFlatBatchInput>> augmentationType, Augmentation<ProcessFlatBatchInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ProcessFlatBatchInputBuilder removeAugmentation(Class<? extends Augmentation<ProcessFlatBatchInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ProcessFlatBatchInput build() {
        return new ProcessFlatBatchInputImpl(this);
    }

    private static final class ProcessFlatBatchInputImpl
    implements ProcessFlatBatchInput {
        private final List<Batch> _batch;
        private final NodeRef _node;
        private final Boolean _exitOnFirstError;
        private Map<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ProcessFlatBatchInput> getImplementedInterface() {
            return ProcessFlatBatchInput.class;
        }

        private ProcessFlatBatchInputImpl(ProcessFlatBatchInputBuilder base) {
            this._batch = base.getBatch();
            this._node = base.getNode();
            this._exitOnFirstError = base.isExitOnFirstError();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Batch> getBatch() {
            return this._batch;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Boolean isExitOnFirstError() {
            return this._exitOnFirstError;
        }

        public <E extends Augmentation<ProcessFlatBatchInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batch);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._exitOnFirstError);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ProcessFlatBatchInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ProcessFlatBatchInput other = (ProcessFlatBatchInput)obj;
            if (!Objects.equals(this._batch, other.getBatch())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._exitOnFirstError, other.isExitOnFirstError())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProcessFlatBatchInputImpl otherImpl = (ProcessFlatBatchInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ProcessFlatBatchInput>>, Augmentation<ProcessFlatBatchInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ProcessFlatBatchInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batch != null) {
                builder.append("_batch=");
                builder.append(this._batch);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._exitOnFirstError != null) {
                builder.append("_exitOnFirstError=");
                builder.append(this._exitOnFirstError);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

