/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch;

import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.infrautils.utils.concurrent.LoggingFutures;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.openflowplugin.learningswitch.DataTreeChangeListenerRegistrationHolder;
import org.opendaylight.openflowplugin.learningswitch.FlowCommitWrapper;
import org.opendaylight.openflowplugin.learningswitch.FlowUtils;
import org.opendaylight.openflowplugin.learningswitch.InstanceIdentifierUtils;
import org.opendaylight.openflowplugin.learningswitch.LearningSwitchHandler;
import org.opendaylight.openflowplugin.learningswitch.PacketUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInputBuilder;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearningSwitchHandlerSimpleImpl
implements LearningSwitchHandler,
NotificationService.Listener<PacketReceived> {
    private static final Logger LOG = LoggerFactory.getLogger(LearningSwitchHandlerSimpleImpl.class);
    private static final byte[] ETH_TYPE_IPV4 = new byte[]{8, 0};
    private static final Uint16 DIRECT_FLOW_PRIORITY = Uint16.valueOf((int)512);
    private final DataTreeChangeListenerRegistrationHolder registrationPublisher;
    private final FlowCommitWrapper dataStoreAccessor;
    private final TransmitPacket transmitPacket;
    private volatile boolean isLearning = false;
    private NodeId nodeId;
    private final AtomicLong flowIdInc = new AtomicLong();
    private final AtomicLong flowCookieInc = new AtomicLong(0x2A00000000000000L);
    private InstanceIdentifier<Node> nodePath;
    private volatile InstanceIdentifier<Table> tablePath;
    private Map<MacAddress, NodeConnectorRef> mac2portMapping;
    private final Set<String> coveredMacPaths = new HashSet<String>();

    public LearningSwitchHandlerSimpleImpl(@NonNull FlowCommitWrapper dataStoreAccessor, @NonNull TransmitPacket transmitPacket, @Nullable DataTreeChangeListenerRegistrationHolder registrationPublisher) {
        this.dataStoreAccessor = Objects.requireNonNull(dataStoreAccessor);
        this.transmitPacket = Objects.requireNonNull(transmitPacket);
        this.registrationPublisher = registrationPublisher;
    }

    @Override
    public synchronized void onSwitchAppeared(InstanceIdentifier<Table> appearedTablePath) {
        if (this.isLearning) {
            LOG.debug("already learning a node, skipping {}", (Object)this.nodeId.getValue());
            return;
        }
        LOG.debug("expected table acquired, learning ..");
        if (this.registrationPublisher != null) {
            LOG.debug("closing dataTreeChangeListenerRegistration");
            this.registrationPublisher.getDataTreeChangeListenerRegistration().close();
        }
        this.isLearning = true;
        this.tablePath = appearedTablePath;
        this.nodePath = this.tablePath.firstIdentifierOf(Node.class);
        this.nodeId = ((NodeKey)this.nodePath.firstKeyOf(Node.class)).getId();
        this.mac2portMapping = new HashMap<MacAddress, NodeConnectorRef>();
        FlowId flowId = new FlowId(String.valueOf(this.flowIdInc.getAndIncrement()));
        FlowKey flowKey = new FlowKey(flowId);
        InstanceIdentifier<Flow> flowPath = InstanceIdentifierUtils.createFlowPath(this.tablePath, flowKey);
        Uint16 priority = Uint16.ZERO;
        FlowBuilder allToCtrlFlow = FlowUtils.createFwdAllToControllerFlow(InstanceIdentifierUtils.getTableId(this.tablePath), priority, flowId);
        LOG.debug("writing packetForwardToController flow");
        this.dataStoreAccessor.writeFlowToConfig(flowPath, allToCtrlFlow.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification(PacketReceived notification) {
        if (!this.isLearning) {
            return;
        }
        LOG.debug("Received packet via match: {}", (Object)notification.getMatch());
        if (!this.nodePath.contains(notification.getIngress().getValue())) {
            return;
        }
        byte[] dstMacRaw = PacketUtils.extractDstMac(notification.getPayload());
        byte[] srcMacRaw = PacketUtils.extractSrcMac(notification.getPayload());
        byte[] etherType = PacketUtils.extractEtherType(notification.getPayload());
        MacAddress dstMac = PacketUtils.rawMacToMac(dstMacRaw);
        MacAddress srcMac = PacketUtils.rawMacToMac(srcMacRaw);
        NodeConnectorKey ingressKey = InstanceIdentifierUtils.getNodeConnectorKey(notification.getIngress().getValue());
        LOG.debug("Received packet from MAC match: {}, ingress: {}", (Object)srcMac, (Object)ingressKey.getId());
        LOG.debug("Received packet to   MAC match: {}", (Object)dstMac);
        LOG.debug("Ethertype: {}", (Object)Integer.toHexString(0xFFFF & ByteBuffer.wrap(etherType).getShort()));
        if (Arrays.equals(ETH_TYPE_IPV4, etherType)) {
            NodeConnectorRef destNodeConnector;
            NodeConnectorRef previousPort = this.mac2portMapping.put(srcMac, notification.getIngress());
            if (previousPort != null && !notification.getIngress().equals((Object)previousPort)) {
                NodeConnectorKey previousPortKey = InstanceIdentifierUtils.getNodeConnectorKey(previousPort.getValue());
                LOG.debug("mac2port mapping changed by mac {}: {} -> {}", new Object[]{srcMac, previousPortKey, ingressKey.getId()});
            }
            if ((destNodeConnector = this.mac2portMapping.get(dstMac)) != null) {
                Set<String> set = this.coveredMacPaths;
                synchronized (set) {
                    if (!destNodeConnector.equals((Object)notification.getIngress())) {
                        this.addBridgeFlow(srcMac, dstMac, destNodeConnector);
                        this.addBridgeFlow(dstMac, srcMac, notification.getIngress());
                    } else {
                        LOG.debug("useless rule ignoring - both MACs are behind the same port");
                    }
                }
                LOG.debug("packetIn-directing.. to {}", (Object)InstanceIdentifierUtils.getNodeConnectorKey(destNodeConnector.getValue()).getId());
                this.sendPacketOut(notification.getPayload(), notification.getIngress(), destNodeConnector);
            } else {
                LOG.debug("packetIn-still flooding.. ");
                this.flood(notification.getPayload(), notification.getIngress());
            }
        } else {
            this.flood(notification.getPayload(), notification.getIngress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBridgeFlow(MacAddress srcMac, MacAddress dstMac, NodeConnectorRef destNodeConnector) {
        Set<String> set = this.coveredMacPaths;
        synchronized (set) {
            String macPath = srcMac.toString() + dstMac.toString();
            if (!this.coveredMacPaths.contains(macPath)) {
                LOG.debug("covering mac path: {} by [{}]", (Object)macPath, (Object)((NodeConnectorKey)destNodeConnector.getValue().firstKeyOf(NodeConnector.class)).getId());
                this.coveredMacPaths.add(macPath);
                FlowId flowId = new FlowId(String.valueOf(this.flowIdInc.getAndIncrement()));
                FlowKey flowKey = new FlowKey(flowId);
                InstanceIdentifier<Flow> flowPath = InstanceIdentifierUtils.createFlowPath(this.tablePath, flowKey);
                Uint8 tableId = InstanceIdentifierUtils.getTableId(this.tablePath);
                FlowBuilder srcToDstFlow = FlowUtils.createDirectMacToMacFlow(tableId, DIRECT_FLOW_PRIORITY, srcMac, dstMac, destNodeConnector);
                srcToDstFlow.setCookie(new FlowCookie(Uint64.valueOf((long)this.flowCookieInc.getAndIncrement())));
                this.dataStoreAccessor.writeFlowToConfig(flowPath, srcToDstFlow.build());
            }
        }
    }

    private void flood(byte[] payload, NodeConnectorRef ingress) {
        NodeConnectorKey nodeConnectorKey = new NodeConnectorKey(this.nodeConnectorId("0xfffffffb"));
        InstanceIdentifier<NodeConnector> nodeConnectorPath = InstanceIdentifierUtils.createNodeConnectorPath(this.nodePath, nodeConnectorKey);
        NodeConnectorRef egressConnectorRef = new NodeConnectorRef(nodeConnectorPath);
        this.sendPacketOut(payload, ingress, egressConnectorRef);
    }

    private NodeConnectorId nodeConnectorId(String connectorId) {
        NodeKey nodeKey = (NodeKey)this.nodePath.firstKeyOf(Node.class);
        StringBuilder stringId = new StringBuilder(nodeKey.getId().getValue()).append(":").append(connectorId);
        return new NodeConnectorId(stringId.toString());
    }

    private void sendPacketOut(byte[] payload, NodeConnectorRef ingress, NodeConnectorRef egress) {
        LoggingFutures.addErrorLogging((ListenableFuture)this.transmitPacket.invoke(new TransmitPacketInputBuilder().setPayload(payload).setNode(new NodeRef(InstanceIdentifierUtils.getNodePath(egress.getValue()))).setEgress(egress).setIngress(ingress).build()), (Logger)LOG, (String)"transmitPacket");
    }
}

