/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatPermCollectorImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetAllGroupStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupDescriptionInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupFeaturesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.OpendaylightGroupStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterConfigStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetMeterFeaturesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.OpendaylightMeterStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromAllPortsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.OpendaylightQueueStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatRpcMsgManagerImpl
implements StatRpcMsgManager {
    private static final Logger LOG = LoggerFactory.getLogger(StatRpcMsgManagerImpl.class);
    private final Cache<String, StatRpcMsgManager.TransactionCacheContainer<? super TransactionAware>> txCache;
    private final Cache<String, SettableFuture<Boolean>> txFutureCache;
    private static final long TXCACHE_WAIT_TIMEOUT = 10L;
    private static final int MAX_CACHE_SIZE = 10000;
    private static final String MSG_TRANS_ID_NOT_NULL = "TransactionId can not be null!";
    private static final String MSG_NODE_ID_NOT_NULL = "NodeId can not be null!";
    private static final String MSG_NODE_REF_NOT_NULL = "NodeRef can not be null!";
    private static final long POSSIBLE_STAT_WAIT_FOR_NOTIFICATION = 7L;
    private final OpendaylightGroupStatisticsService groupStatsService;
    private final OpendaylightMeterStatisticsService meterStatsService;
    private final OpendaylightFlowStatisticsService flowStatsService;
    private final OpendaylightPortStatisticsService portStatsService;
    private final OpendaylightFlowTableStatisticsService flowTableStatsService;
    private final OpendaylightQueueStatisticsService queueStatsService;

    public StatRpcMsgManagerImpl(StatisticsManager manager, RpcConsumerRegistry rpcRegistry, long maxNodeForCollector) {
        Preconditions.checkArgument((manager != null ? 1 : 0) != 0, (Object)"StatisticManager can not be null!");
        Preconditions.checkArgument((rpcRegistry != null ? 1 : 0) != 0, (Object)"RpcConsumerRegistry can not be null !");
        this.groupStatsService = (OpendaylightGroupStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightGroupStatisticsService.class), (Object)"OpendaylightGroupStatisticsService can not be null!");
        this.meterStatsService = (OpendaylightMeterStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightMeterStatisticsService.class), (Object)"OpendaylightMeterStatisticsService can not be null!");
        this.flowStatsService = (OpendaylightFlowStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightFlowStatisticsService.class), (Object)"OpendaylightFlowStatisticsService can not be null!");
        this.portStatsService = (OpendaylightPortStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightPortStatisticsService.class), (Object)"OpendaylightPortStatisticsService can not be null!");
        this.flowTableStatsService = (OpendaylightFlowTableStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightFlowTableStatisticsService.class), (Object)"OpendaylightFlowTableStatisticsService can not be null!");
        this.queueStatsService = (OpendaylightQueueStatisticsService)Preconditions.checkNotNull((Object)rpcRegistry.getRpcService(OpendaylightQueueStatisticsService.class), (Object)"OpendaylightQueueStatisticsService can not be null!");
        this.txCache = CacheBuilder.newBuilder().expireAfterWrite(maxNodeForCollector * 7L, TimeUnit.SECONDS).maximumSize(10000L).build();
        this.txFutureCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(10000L).build();
    }

    @Override
    public <T extends TransactionAware, D extends DataObject> void registrationRpcFutureCallBack(Future<RpcResult<T>> future, final D inputObj, final NodeRef nodeRef, final SettableFuture<TransactionId> resultTransId) {
        class FutureCallbackImpl
        implements FutureCallback<RpcResult<? extends TransactionAware>> {
            FutureCallbackImpl() {
            }

            public void onSuccess(RpcResult<? extends TransactionAware> result) {
                TransactionId id = ((TransactionAware)result.getResult()).getTransactionId();
                NodeKey nodeKey = (NodeKey)nodeRef.getValue().firstKeyOf(Node.class, NodeKey.class);
                if (id == null) {
                    String[] multipartRequestName = ((TransactionAware)result.getResult()).getClass().getSimpleName().split("(?=\\p{Upper})");
                    LOG.warn("Node [{}] does not support statistics request type : {}", (Object)nodeKey.getId(), (Object)Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(multipartRequestName, 2, multipartRequestName.length - 2)));
                    if (resultTransId != null) {
                        resultTransId.setException((Throwable)new UnsupportedOperationException());
                    }
                } else {
                    if (resultTransId != null) {
                        resultTransId.set((Object)id);
                    }
                    String cacheKey = StatRpcMsgManagerImpl.this.buildCacheKey(id, nodeKey.getId());
                    TransactionCacheContainerImpl container = new TransactionCacheContainerImpl(id, inputObj, nodeKey.getId());
                    StatRpcMsgManagerImpl.this.putTransaction(cacheKey, container);
                }
            }

            public void onFailure(Throwable t) {
                LOG.warn("Response Registration for Statistics RPC call fail!", t);
                if (resultTransId != null) {
                    if (t instanceof DOMRpcImplementationNotAvailableException) {
                        resultTransId.set((Object)StatPermCollectorImpl.getFakeTxId());
                    } else {
                        resultTransId.setException(t);
                    }
                }
            }
        }
        Futures.addCallback((ListenableFuture)JdkFutureAdapters.listenInPoolThread(future), (FutureCallback)new FutureCallbackImpl());
    }

    private String buildCacheKey(TransactionId id, NodeId nodeId) {
        return String.valueOf(id.getValue()) + "-" + nodeId.getValue();
    }

    private synchronized void putTransaction(String key, StatRpcMsgManager.TransactionCacheContainer<? super TransactionAware> container) {
        this.txCache.put((Object)key, container);
        SettableFuture future = (SettableFuture)this.txFutureCache.asMap().remove(key);
        if (future != null) {
            future.set((Object)true);
        }
    }

    private synchronized Future<Boolean> isExpectedStatistics(String key) {
        ListenableFuture future;
        StatRpcMsgManager.TransactionCacheContainer container = (StatRpcMsgManager.TransactionCacheContainer)this.txCache.getIfPresent((Object)key);
        if (container == null) {
            SettableFuture f = SettableFuture.create();
            SettableFuture current = this.txFutureCache.asMap().putIfAbsent(key, f);
            future = current == null ? f : current;
        } else {
            future = Futures.immediateFuture((Object)Boolean.TRUE);
        }
        return future;
    }

    @Override
    public Future<Optional<StatRpcMsgManager.TransactionCacheContainer<?>>> getTransactionCacheContainer(TransactionId id, NodeId nodeId) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_TRANS_ID_NOT_NULL);
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)MSG_NODE_ID_NOT_NULL);
        String key = this.buildCacheKey(id, nodeId);
        Optional resultContainer = Optional.fromNullable(this.txCache.asMap().remove(key));
        if (!resultContainer.isPresent()) {
            LOG.warn("Transaction cache not found: {}", (Object)key);
        }
        return Futures.immediateFuture((Object)resultContainer);
    }

    @Override
    public Future<Boolean> isExpectedStatistics(TransactionId id, NodeId nodeId) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_TRANS_ID_NOT_NULL);
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)MSG_NODE_ID_NOT_NULL);
        String key = this.buildCacheKey(id, nodeId);
        return this.isExpectedStatistics(key);
    }

    public void addNotification(TransactionAware notification, NodeId nodeId) {
        Preconditions.checkArgument((notification != null ? 1 : 0) != 0, (Object)"TransactionAware can not be null!");
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)MSG_NODE_ID_NOT_NULL);
        TransactionId txId = notification.getTransactionId();
        String key = this.buildCacheKey(txId, nodeId);
        StatRpcMsgManager.TransactionCacheContainer container = (StatRpcMsgManager.TransactionCacheContainer)this.txCache.getIfPresent((Object)key);
        if (container != null) {
            container.addNotif(notification);
        } else {
            LOG.warn("Unable to add notification: {}, {}", (Object)key, (Object)notification.getImplementedInterface());
        }
    }

    @Override
    public Future<TransactionId> getAllGroupsStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetAllGroupStatisticsInputBuilder builder = new GetAllGroupStatisticsInputBuilder();
        builder.setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.groupStatsService.getAllGroupStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    @Override
    public Future<TransactionId> getAllMetersStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetAllMeterStatisticsInputBuilder builder = new GetAllMeterStatisticsInputBuilder();
        builder.setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.meterStatsService.getAllMeterStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    @Override
    public Future<TransactionId> getAllFlowsStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetAllFlowsStatisticsFromAllFlowTablesInputBuilder builder = new GetAllFlowsStatisticsFromAllFlowTablesInputBuilder();
        builder.setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.flowStatsService.getAllFlowsStatisticsFromAllFlowTables(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    @Override
    public void getAggregateFlowStat(NodeRef nodeRef, TableId tableId) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"TableId can not be null!");
        GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder builder = new GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder();
        builder.setNode(nodeRef).setTableId(tableId);
        TableBuilder tbuilder = new TableBuilder().setId(tableId.getValue()).setKey(new TableKey(tableId.getValue()));
        this.registrationRpcFutureCallBack(this.flowStatsService.getAggregateFlowStatisticsFromFlowTableForAllFlows(builder.build()), tbuilder.build(), nodeRef, null);
    }

    @Override
    public Future<TransactionId> getAllPortsStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetAllNodeConnectorsStatisticsInputBuilder builder = new GetAllNodeConnectorsStatisticsInputBuilder();
        builder.setNode(nodeRef);
        Future rpc = this.portStatsService.getAllNodeConnectorsStatistics(builder.build());
        this.registrationRpcFutureCallBack(rpc, null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    @Override
    public Future<TransactionId> getAllTablesStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetFlowTablesStatisticsInputBuilder builder = new GetFlowTablesStatisticsInputBuilder();
        builder.setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.flowTableStatsService.getFlowTablesStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    @Override
    public Future<TransactionId> getAllQueueStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetAllQueuesStatisticsFromAllPortsInputBuilder builder = new GetAllQueuesStatisticsFromAllPortsInputBuilder();
        builder.setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.queueStatsService.getAllQueuesStatisticsFromAllPorts(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    @Override
    public Future<TransactionId> getAllMeterConfigStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetAllMeterConfigStatisticsInputBuilder builder = new GetAllMeterConfigStatisticsInputBuilder();
        builder.setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.meterStatsService.getAllMeterConfigStatistics(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    @Override
    public void getGroupFeaturesStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        GetGroupFeaturesInputBuilder input = new GetGroupFeaturesInputBuilder().setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.groupStatsService.getGroupFeatures(input.build()), null, nodeRef, null);
    }

    @Override
    public void getMeterFeaturesStat(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        GetMeterFeaturesInputBuilder input = new GetMeterFeaturesInputBuilder().setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.meterStatsService.getMeterFeatures(input.build()), null, nodeRef, null);
    }

    @Override
    public Future<TransactionId> getAllGroupsConfStats(NodeRef nodeRef) {
        Preconditions.checkArgument((nodeRef != null ? 1 : 0) != 0, (Object)MSG_NODE_REF_NOT_NULL);
        SettableFuture result = SettableFuture.create();
        GetGroupDescriptionInputBuilder builder = new GetGroupDescriptionInputBuilder();
        builder.setNode(nodeRef);
        this.registrationRpcFutureCallBack(this.groupStatsService.getGroupDescription(builder.build()), null, nodeRef, (SettableFuture<TransactionId>)result);
        return result;
    }

    public class TransactionCacheContainerImpl<T extends TransactionAware>
    implements StatRpcMsgManager.TransactionCacheContainer<T> {
        private final TransactionId id;
        private final NodeId nId;
        private final List<T> notifications;
        private final Optional<? extends DataObject> confInput;

        public <D extends DataObject> TransactionCacheContainerImpl(TransactionId id, D input, NodeId nodeId) {
            this.id = (TransactionId)Preconditions.checkNotNull((Object)id, (Object)StatRpcMsgManagerImpl.MSG_TRANS_ID_NOT_NULL);
            this.notifications = new CopyOnWriteArrayList<T>();
            this.confInput = Optional.fromNullable(input);
            this.nId = nodeId;
        }

        @Override
        public void addNotif(T notif) {
            this.notifications.add(notif);
        }

        @Override
        public TransactionId getId() {
            return this.id;
        }

        @Override
        public NodeId getNodeId() {
            return this.nId;
        }

        @Override
        public List<T> getNotifications() {
            return this.notifications;
        }

        @Override
        public Optional<? extends DataObject> getConfInput() {
            return this.confInput;
        }
    }
}

