/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatListeningCommiter;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractNotifyCommit;
import org.opendaylight.openflowplugin.common.wait.SimpleTaskRetryLooper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatAbstractListenCommit<T extends DataObject, N extends NotificationListener>
extends StatAbstractNotifyCommit<N>
implements StatListeningCommiter<T, N> {
    private static final Logger LOG = LoggerFactory.getLogger(StatAbstractListenCommit.class);
    private ListenerRegistration<StatAbstractListenCommit<T, N>> listenerRegistration;
    protected final Map<InstanceIdentifier<Node>, Map<InstanceIdentifier<T>, Integer>> mapNodesForDelete = new ConcurrentHashMap<InstanceIdentifier<Node>, Map<InstanceIdentifier<T>, Integer>>();
    protected final Map<InstanceIdentifier<Node>, Integer> mapNodeFeautureRepeater = new ConcurrentHashMap<InstanceIdentifier<Node>, Integer>();
    protected final Map<InstanceIdentifier<Node>, ArrayList<T>> removedDataBetweenStatsCycle = new ConcurrentHashMap<InstanceIdentifier<Node>, ArrayList<T>>();
    private final Class<T> clazz;
    protected final DataBroker dataBroker;
    protected final StatNodeRegistration nodeRegistrationManager;
    private ReadOnlyTransaction currentReadTx;
    private volatile boolean currentReadTxStale;
    private static final int STARTUP_LOOP_TICK = 500;
    private static final int STARTUP_LOOP_MAX_RETRIES = 8;
    private final DataTreeIdentifier<T> treeId = new DataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, this.getWildCardedRegistrationPath());

    public StatAbstractListenCommit(StatisticsManager manager, final DataBroker db, NotificationProviderService nps, Class<T> clazz, StatNodeRegistration nodeRegistrationManager) {
        super(manager, nps, nodeRegistrationManager);
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"Referenced Class can not be null");
        Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"DataBroker can not be null!");
        this.dataBroker = db;
        this.nodeRegistrationManager = nodeRegistrationManager;
        SimpleTaskRetryLooper looper = new SimpleTaskRetryLooper(500L, 8);
        try {
            this.listenerRegistration = (ListenerRegistration)looper.loopUntilNoException(new Callable<ListenerRegistration<StatAbstractListenCommit<T, N>>>(){

                @Override
                public ListenerRegistration<StatAbstractListenCommit<T, N>> call() throws Exception {
                    return db.registerDataTreeChangeListener(StatAbstractListenCommit.this.treeId, (DataTreeChangeListener)StatAbstractListenCommit.this);
                }
            });
        }
        catch (Exception ex) {
            LOG.debug(" StatAbstractListenCommit DataTreeChangeListener registration failed {}", (Object)ex.getMessage());
            throw new IllegalStateException("Notification supplier startup fail! System needs restart.", ex);
        }
    }

    protected abstract InstanceIdentifier<T> getWildCardedRegistrationPath();

    protected abstract void processDataChange(Collection<DataTreeModification<T>> var1);

    public void onDataTreeChanged(Collection<DataTreeModification<T>> changes) {
        Preconditions.checkNotNull(changes, (Object)"Changes must not be null!");
        this.currentReadTxStale = true;
        this.processDataChange(changes);
    }

    protected void removeData(InstanceIdentifier<?> key, Integer value) {
        if (this.clazz.equals(key.getTargetType())) {
            InstanceIdentifier nodeIdent = key.firstIdentifierOf(Node.class);
            Map<InstanceIdentifier<T>, Integer> map = null;
            if (this.mapNodesForDelete.containsKey(nodeIdent)) {
                map = this.mapNodesForDelete.get(nodeIdent);
            }
            if (map == null) {
                map = new ConcurrentHashMap<InstanceIdentifier<T>, Integer>();
                this.mapNodesForDelete.put((InstanceIdentifier<Node>)nodeIdent, map);
            }
            map.put(key, value);
        }
    }

    @Override
    public void cleanForDisconnect(InstanceIdentifier<Node> nodeIdent) {
        this.mapNodesForDelete.remove(nodeIdent);
        this.removedDataBetweenStatsCycle.remove(nodeIdent);
    }

    @Override
    public void close() {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error by stop {} DataTreeChangeListener StatListeningCommiter.", (Object)this.clazz.getSimpleName(), (Object)e);
            }
            this.listenerRegistration = null;
        }
        super.close();
    }

    protected final <K extends DataObject> Optional<K> readLatestConfiguration(InstanceIdentifier<K> path) {
        for (int i = 0; i < 2; ++i) {
            boolean localReadTxStale = this.currentReadTxStale;
            ReadOnlyTransaction localReadTx = this.currentReadTx;
            if (localReadTx == null || localReadTxStale) {
                if (localReadTx != null) {
                    localReadTx.close();
                }
                this.currentReadTx = localReadTx = this.dataBroker.newReadOnlyTransaction();
                this.currentReadTxStale = false;
            }
            try {
                return (Optional)localReadTx.read(LogicalDatastoreType.CONFIGURATION, path).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("It wasn't possible to read {} from datastore. Exception: {}", path, (Object)e);
                this.currentReadTxStale = true;
                continue;
            }
        }
        return Optional.absent();
    }
}

