/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNotifyCommiter;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatAbstractNotifyCommit<N extends NotificationListener>
implements StatNotifyCommiter<N> {
    private static final Logger LOG = LoggerFactory.getLogger(StatAbstractNotifyCommit.class);
    private static final long MAX_WAIT_TIME = 10L;
    protected final StatisticsManager manager;
    private ListenerRegistration<NotificationListener> notifyListenerRegistration;
    protected final StatNodeRegistration nodeRegistrationManager;

    public StatAbstractNotifyCommit(StatisticsManager manager, NotificationProviderService nps, StatNodeRegistration nodeRegistrationManager) {
        Preconditions.checkArgument((nps != null ? 1 : 0) != 0, (Object)"NotificationProviderService can not be null!");
        this.manager = (StatisticsManager)Preconditions.checkNotNull((Object)manager, (Object)"StatisticManager can not be null!");
        this.notifyListenerRegistration = nps.registerNotificationListener(this.getStatNotificationListener());
        this.nodeRegistrationManager = nodeRegistrationManager;
    }

    @Override
    public void close() {
        if (this.notifyListenerRegistration != null) {
            try {
                this.notifyListenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error by stop {} StatNotificationListener. Exception {}", (Object)this.getClass().getSimpleName(), (Object)e);
            }
            this.notifyListenerRegistration = null;
        }
    }

    protected abstract N getStatNotificationListener();

    protected boolean preConfigurationCheck(InstanceIdentifier<Node> nodeIdent) {
        Preconditions.checkNotNull(nodeIdent, (Object)"FlowCapableNode ident can not be null!");
        return this.manager.isProvidedFlowNodeActive(nodeIdent);
    }

    protected void notifyToCollectNextStatistics(InstanceIdentifier<Node> nodeIdent, TransactionId xid) {
        Preconditions.checkNotNull(nodeIdent, (Object)"FlowCapableNode ident can not be null!");
        this.manager.collectNextStatistics(nodeIdent, xid);
    }

    protected Optional<StatRpcMsgManager.TransactionCacheContainer<?>> getTransactionCacheContainer(TransactionId transId, NodeId nodeId) {
        Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer;
        try {
            txContainer = this.manager.getRpcMsgManager().getTransactionCacheContainer(transId, nodeId).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn("Get TransactionCacheContainer fail!", (Throwable)e);
            txContainer = Optional.absent();
        }
        return txContainer;
    }

    protected boolean isTransactionCacheContainerValid(Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txCacheContainer) {
        if (!txCacheContainer.isPresent()) {
            LOG.debug("Transaction Cache Container is not presented!");
            return false;
        }
        if (((StatRpcMsgManager.TransactionCacheContainer)txCacheContainer.get()).getNodeId() == null) {
            LOG.debug("Transaction Cache Container {} don't have Node ID!", (Object)((StatRpcMsgManager.TransactionCacheContainer)txCacheContainer.get()).getId());
            return false;
        }
        if (((StatRpcMsgManager.TransactionCacheContainer)txCacheContainer.get()).getNotifications() == null) {
            LOG.debug("Transaction Cache Container {} for {} node don't have Notifications!", (Object)((StatRpcMsgManager.TransactionCacheContainer)txCacheContainer.get()).getId(), (Object)((StatRpcMsgManager.TransactionCacheContainer)txCacheContainer.get()).getNodeId());
            return false;
        }
        return true;
    }

    protected boolean isExpectedStatistics(TransactionId transId, NodeId nodeId) {
        Boolean isExpectedStat = Boolean.FALSE;
        try {
            isExpectedStat = this.manager.getRpcMsgManager().isExpectedStatistics(transId, nodeId).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn("Check Transaction registraion {} fail!", (Object)transId, (Object)e);
            return false;
        }
        return isExpectedStat;
    }
}

