package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.config.rev160509;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>statistics-manager-app-config</b>
 * <pre>
 * container statistics-manager-app-config {
 *     leaf min-request-net-monitor-interval {
 *         type min-request-net-monitor-interval;
 *     }
 *     leaf max-nodes-for-collector {
 *         type max-nodes-for-collector;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>statistics-manager-app-config/statistics-manager-app-config</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.config.rev160509.StatisticsManagerAppConfigBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.config.rev160509.StatisticsManagerAppConfigBuilder
 *
 */
public interface StatisticsManagerAppConfig
    extends
    ChildOf<StatisticsManagerAppConfigData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.config.rev160509.StatisticsManagerAppConfig>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:openflowplugin:app:statistics-manager:config",
        "2016-05-09", "statistics-manager-app-config").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>minRequestNetMonitorInterval</code>, or <code>null</code> if not present
     */
    java.lang.Integer getMinRequestNetMonitorInterval();
    
    /**
     * @return <code>java.lang.Integer</code> <code>maxNodesForCollector</code>, or <code>null</code> if not present
     */
    java.lang.Integer getMaxNodesForCollector();

}

