package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.config.rev160509;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * Configuration for Statistics Manager application.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>statistics-manager-app-config</b>
 * <pre>
 * module statistics-manager-app-config {
 *     yang-version 1;
 *     namespace "urn:opendaylight:params:xml:ns:yang:openflowplugin:app:statistics-manager:config";
 *     prefix "statistics-manager-app-config";
 *
 *     revision 2016-05-09 {
 *         description "Configuration for Statistics Manager application.
 *         ";
 *     }
 *
 *     container statistics-manager-app-config {
 *         leaf min-request-net-monitor-interval {
 *             type min-request-net-monitor-interval;
 *         }
 *         leaf max-nodes-for-collector {
 *             type max-nodes-for-collector;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface StatisticsManagerAppConfigData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.config.rev160509.StatisticsManagerAppConfig</code> <code>statisticsManagerAppConfig</code>, or <code>null</code> if not present
     */
    StatisticsManagerAppConfig getStatisticsManagerAppConfig();

}

