/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.clustering.Entity;
import org.opendaylight.controller.md.sal.common.api.clustering.EntityOwnershipChange;
import org.opendaylight.controller.md.sal.common.api.clustering.EntityOwnershipListener;
import org.opendaylight.controller.md.sal.common.api.clustering.EntityOwnershipListenerRegistration;
import org.opendaylight.controller.md.sal.common.api.clustering.EntityOwnershipService;
import org.opendaylight.controller.md.sal.common.api.clustering.EntityOwnershipState;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatPermCollector;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityGroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityQueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityTableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatNodeRegistrationImpl
implements StatNodeRegistration,
EntityOwnershipListener {
    private static final Logger LOG = LoggerFactory.getLogger(StatNodeRegistrationImpl.class);
    private static final QName ENTITY_QNAME = org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.core.general.entity.rev150820.Entity.QNAME;
    private static final QName ENTITY_NAME = QName.create((QName)ENTITY_QNAME, (String)"name");
    private final StatisticsManager manager;
    private ListenerRegistration<?> notifListenerRegistration;
    private EntityOwnershipListenerRegistration ofListenerRegistration = null;
    private final Map<NodeId, Boolean> nodeOwnershipState = new ConcurrentHashMap<NodeId, Boolean>();

    public StatNodeRegistrationImpl(StatisticsManager manager, DataBroker db, NotificationProviderService notificationService) {
        this.manager = (StatisticsManager)Preconditions.checkNotNull((Object)manager, (Object)"StatisticManager can not be null!");
        Preconditions.checkArgument((notificationService != null ? 1 : 0) != 0, (Object)"NotificationProviderService can not be null!");
        this.notifListenerRegistration = notificationService.registerNotificationListener((NotificationListener)this);
        if (manager.getOwnershipService() != null) {
            this.ofListenerRegistration = manager.getOwnershipService().registerListener("openflow", (EntityOwnershipListener)this);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.notifListenerRegistration != null) {
            try {
                this.notifListenerRegistration.close();
            }
            catch (Exception e) {
                LOG.warn("Error by stop FlowCapableNode Notification StatNodeRegistration. Exception {}", (Throwable)e);
            }
            this.notifListenerRegistration = null;
        }
        if (this.ofListenerRegistration != null) {
            try {
                this.ofListenerRegistration.close();
            }
            catch (Exception e) {
                LOG.warn("Error by stop FlowCapableNode EntityOwnershipListener.", (Throwable)e);
            }
            this.ofListenerRegistration = null;
        }
    }

    @Override
    public void connectFlowCapableNode(InstanceIdentifier<SwitchFeatures> keyIdent, SwitchFeatures data, InstanceIdentifier<Node> nodeIdent) {
        Preconditions.checkNotNull(keyIdent, (Object)"InstanceIdentifier can not be null!");
        Preconditions.checkNotNull((Object)data, (String)"SwitchFeatures data for {} can not be null!", (Object[])new Object[]{keyIdent});
        Preconditions.checkArgument((!keyIdent.isWildcarded() ? 1 : 0) != 0, (Object)"InstanceIdentifier is WildCarded!");
        LOG.trace("STAT-MANAGER - connecting flow capable node {}", nodeIdent);
        ArrayList<StatPermCollector.StatCapabTypes> statCapabTypes = new ArrayList<StatPermCollector.StatCapabTypes>();
        Short maxCapTables = Short.valueOf("1");
        List capabilities = data.getCapabilities() != null ? data.getCapabilities() : Collections.emptyList();
        for (Class capability : capabilities) {
            if (FlowFeatureCapabilityTableStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.TABLE_STATS);
                continue;
            }
            if (FlowFeatureCapabilityFlowStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.FLOW_STATS);
                continue;
            }
            if (FlowFeatureCapabilityGroupStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.GROUP_STATS);
                continue;
            }
            if (FlowFeatureCapabilityPortStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.PORT_STATS);
                continue;
            }
            if (!FlowFeatureCapabilityQueueStats.class.equals((Object)capability)) continue;
            statCapabTypes.add(StatPermCollector.StatCapabTypes.QUEUE_STATS);
        }
        maxCapTables = data.getMaxTables();
        Optional maxTables = Optional.of((Object)maxCapTables);
        this.manager.connectedNodeRegistration(nodeIdent, Collections.unmodifiableList(statCapabTypes), (Short)maxTables.get());
    }

    @Override
    public void disconnectFlowCapableNode(InstanceIdentifier<Node> nodeIdent) {
        Preconditions.checkArgument((nodeIdent != null ? 1 : 0) != 0, (Object)"InstanceIdentifier can not be NULL!");
        Preconditions.checkArgument((!nodeIdent.isWildcarded() ? 1 : 0) != 0, (String)"InstanceIdentifier {} is WildCarded!", (Object[])new Object[]{nodeIdent});
        LOG.trace("STAT-MANAGER - disconnect flow capable node {}", nodeIdent);
        this.manager.disconnectedNodeUnregistration(nodeIdent);
    }

    private boolean preConfigurationCheck(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)"Node Instance Identifier can not be null!");
        Entity entity = this.getEntity(nodeId);
        EntityOwnershipService ownershipService = this.manager.getOwnershipService();
        if (ownershipService == null) {
            LOG.error("preConfigurationCheck: EntityOwnershipService is null");
            return false;
        }
        Optional entityOwnershipStateOptional = ownershipService.getOwnershipState(entity);
        if (!entityOwnershipStateOptional.isPresent()) {
            LOG.warn("preConfigurationCheck: Entity state of {} is absent - acting as a non-owner", (Object)nodeId.getValue());
            return false;
        }
        EntityOwnershipState entityOwnershipState = (EntityOwnershipState)entityOwnershipStateOptional.get();
        if (!entityOwnershipState.hasOwner() || !entityOwnershipState.isOwner()) {
            LOG.info("preConfigurationCheck: Controller is not the owner of {}", (Object)nodeId.getValue());
            return false;
        }
        return true;
    }

    public void onNodeConnectorRemoved(NodeConnectorRemoved notification) {
    }

    public void onNodeConnectorUpdated(NodeConnectorUpdated notification) {
    }

    public void onNodeRemoved(NodeRemoved notification) {
        Preconditions.checkNotNull((Object)notification);
        NodeRef nodeRef = notification.getNodeRef();
        InstanceIdentifier nodeRefIdent = nodeRef.getValue();
        InstanceIdentifier nodeIdent = nodeRefIdent.firstIdentifierOf(Node.class);
        if (nodeIdent != null) {
            LOG.debug("Received onNodeRemoved for node:{} ", (Object)nodeIdent);
            this.removeOwnership(((NodeKey)InstanceIdentifier.keyOf((InstanceIdentifier)nodeIdent)).getId());
            this.disconnectFlowCapableNode((InstanceIdentifier<Node>)nodeIdent);
        }
    }

    public void onNodeUpdated(NodeUpdated notification) {
        Preconditions.checkNotNull((Object)notification);
        FlowCapableNodeUpdated newFlowNode = (FlowCapableNodeUpdated)notification.getAugmentation(FlowCapableNodeUpdated.class);
        LOG.info("Received onNodeUpdated for node {} ", (Object)newFlowNode);
        if (newFlowNode != null && newFlowNode.getSwitchFeatures() != null) {
            NodeRef nodeRef = notification.getNodeRef();
            InstanceIdentifier nodeRefIdent = nodeRef.getValue();
            InstanceIdentifier nodeIdent = nodeRefIdent.firstIdentifierOf(Node.class);
            InstanceIdentifier swichFeaturesIdent = nodeIdent.augmentation(FlowCapableNode.class).child(SwitchFeatures.class);
            SwitchFeatures switchFeatures = newFlowNode.getSwitchFeatures();
            this.connectFlowCapableNode((InstanceIdentifier<SwitchFeatures>)swichFeaturesIdent, switchFeatures, (InstanceIdentifier<Node>)nodeIdent);
            NodeId nodeId = ((NodeKey)InstanceIdentifier.keyOf((InstanceIdentifier)nodeIdent)).getId();
            boolean ownershipState = this.preConfigurationCheck(nodeId);
            this.setNodeOwnership(nodeId, ownershipState);
            if (ownershipState) {
                LOG.info("onNodeUpdated: Send group/meter feature request to the device {}", (Object)nodeIdent);
                this.manager.getRpcMsgManager().getGroupFeaturesStat(nodeRef);
                this.manager.getRpcMsgManager().getMeterFeaturesStat(nodeRef);
            }
        }
    }

    @Override
    public boolean isFlowCapableNodeOwner(NodeId node) {
        if (this.nodeOwnershipState.containsKey(node)) {
            return this.nodeOwnershipState.get(node);
        }
        return false;
    }

    public void ownershipChanged(EntityOwnershipChange ownershipChange) {
        YangInstanceIdentifier yId = ownershipChange.getEntity().getId();
        YangInstanceIdentifier.NodeIdentifierWithPredicates niWPredicates = (YangInstanceIdentifier.NodeIdentifierWithPredicates)yId.getLastPathArgument();
        Map keyValMap = niWPredicates.getKeyValues();
        String nodeIdStr = (String)keyValMap.get(ENTITY_NAME);
        BigInteger dpId = new BigInteger(nodeIdStr.split(":")[1]);
        NodeId nodeId = new NodeId(nodeIdStr);
        this.setNodeOwnership(nodeId, ownershipChange.isOwner());
    }

    private void setNodeOwnership(NodeId node, boolean ownership) {
        this.nodeOwnershipState.put(node, ownership);
    }

    private void removeOwnership(NodeId node) {
        this.nodeOwnershipState.remove(node);
    }

    private Entity getEntity(NodeId nodeId) {
        return new Entity("openflow", nodeId.getValue());
    }
}

