/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatPermCollector;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractListenCommit;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatListenCommitMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupDescStatsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupFeaturesUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupStatisticsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupDescStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.OpendaylightGroupStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.desc.GroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.features.GroupFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.features.GroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.statistics.GroupStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.desc.stats.reply.GroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.GroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.GroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatListenCommitGroup
extends StatAbstractListenCommit<Group, OpendaylightGroupStatisticsListener>
implements OpendaylightGroupStatisticsListener {
    private static final Logger LOG = LoggerFactory.getLogger(StatListenCommitMeter.class);

    public StatListenCommitGroup(StatisticsManager manager, DataBroker db, NotificationProviderService nps, StatNodeRegistration nrm) {
        super(manager, db, nps, Group.class, nrm);
    }

    @Override
    protected OpendaylightGroupStatisticsListener getStatNotificationListener() {
        return this;
    }

    @Override
    protected InstanceIdentifier<Group> getWildCardedRegistrationPath() {
        return InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(Group.class);
    }

    public void onGroupDescStatsUpdated(GroupDescStatsUpdated notification) {
        NodeId nodeId;
        final TransactionId transId = notification.getTransactionId();
        if (!this.isExpectedStatistics(transId, nodeId = notification.getId())) {
            LOG.debug("Unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                InstanceIdentifier fNodeIdent = nodeIdent.augmentation(FlowCapableNode.class);
                Optional fNode = Optional.absent();
                try {
                    fNode = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, fNodeIdent).checkedGet();
                }
                catch (ReadFailedException e) {
                    LOG.debug("Read Operational/DS for FlowCapableNode fail! {}", (Object)fNodeIdent, (Object)e);
                }
                if (!fNode.isPresent()) {
                    return;
                }
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitGroup.this.getTransactionCacheContainer(transId, nodeId);
                if (!StatListenCommitGroup.this.isTransactionCacheContainerValid(txContainer)) {
                    return;
                }
                if (!StatListenCommitGroup.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                List existGroups = ((FlowCapableNode)fNode.get()).getGroup() != null ? ((FlowCapableNode)fNode.get()).getGroup() : Collections.emptyList();
                ArrayList<GroupKey> existGroupKeys = new ArrayList<GroupKey>();
                for (Group group : existGroups) {
                    existGroupKeys.add(group.getKey());
                }
                StatListenCommitGroup.this.statGroupDescCommit(txContainer, tx, (InstanceIdentifier<FlowCapableNode>)fNodeIdent, existGroupKeys);
                StatListenCommitGroup.this.deleteAllNotPresentNode((InstanceIdentifier<FlowCapableNode>)fNodeIdent, tx, Collections.unmodifiableList(existGroupKeys));
                StatListenCommitGroup.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)nodeIdent, transId);
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitGroup.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    public void onGroupFeaturesUpdated(GroupFeaturesUpdated notification) {
        Preconditions.checkNotNull((Object)notification);
        final TransactionId transId = notification.getTransactionId();
        final NodeId nodeId = notification.getId();
        if (!this.isExpectedStatistics(transId, nodeId)) {
            LOG.debug("Unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                TransactionAware notif;
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitGroup.this.getTransactionCacheContainer(transId, nodeId);
                if (!StatListenCommitGroup.this.isTransactionCacheContainerValid(txContainer)) {
                    return;
                }
                if (!StatListenCommitGroup.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                Iterator i$ = cacheNotifs.iterator();
                while (i$.hasNext() && (notif = (TransactionAware)i$.next()) instanceof GroupFeaturesUpdated) {
                    GroupFeatures stats = new GroupFeaturesBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures)((GroupFeaturesUpdated)notif)).build();
                    InstanceIdentifier nodeGroupFeatureIdent = nodeIdent.augmentation(NodeGroupFeatures.class);
                    InstanceIdentifier groupFeatureIdent = nodeGroupFeatureIdent.child(GroupFeatures.class);
                    Optional node = Optional.absent();
                    try {
                        node = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeIdent).checkedGet();
                    }
                    catch (ReadFailedException e) {
                        LOG.debug("Read Operational/DS for Node fail! {}", (Object)nodeIdent, (Object)e);
                    }
                    if (!node.isPresent()) continue;
                    tx.merge(LogicalDatastoreType.OPERATIONAL, nodeGroupFeatureIdent, (DataObject)new NodeGroupFeaturesBuilder().build(), true);
                    tx.put(LogicalDatastoreType.OPERATIONAL, groupFeatureIdent, (DataObject)stats);
                    StatListenCommitGroup.this.manager.registerAdditionalNodeFeature((InstanceIdentifier<Node>)nodeIdent, StatPermCollector.StatCapabTypes.GROUP_STATS);
                }
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitGroup.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    public void onGroupStatisticsUpdated(GroupStatisticsUpdated notification) {
        Preconditions.checkNotNull((Object)notification);
        final TransactionId transId = notification.getTransactionId();
        final NodeId nodeId = notification.getId();
        if (!this.isExpectedStatistics(transId, nodeId)) {
            LOG.debug("STAT-MANAGER - GroupStatisticsUpdated: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                TransactionAware notif;
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                Optional node = Optional.absent();
                try {
                    node = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeIdent).checkedGet();
                }
                catch (ReadFailedException e) {
                    LOG.debug("Read Operational/DS for Node fail! {}", (Object)nodeIdent, (Object)e);
                }
                if (!node.isPresent()) {
                    return;
                }
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitGroup.this.getTransactionCacheContainer(transId, nodeId);
                if (!StatListenCommitGroup.this.isTransactionCacheContainerValid(txContainer)) {
                    return;
                }
                if (!StatListenCommitGroup.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                Optional notifGroup = Optional.absent();
                Optional<DataObject> inputObj = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getConfInput();
                if (inputObj.isPresent() && inputObj.get() instanceof Group) {
                    notifGroup = Optional.of((Object)((Group)inputObj.get()));
                }
                Iterator i$ = cacheNotifs.iterator();
                while (i$.hasNext() && (notif = (TransactionAware)i$.next()) instanceof GroupStatisticsUpdated) {
                    StatListenCommitGroup.this.statGroupCommit(((GroupStatisticsUpdated)notif).getGroupStats(), (InstanceIdentifier<Node>)((InstanceIdentifier)nodeIdent), tx);
                }
                if (!notifGroup.isPresent()) {
                    StatListenCommitGroup.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)nodeIdent, transId);
                }
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitGroup.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    private void statGroupCommit(List<GroupStats> groupStats, InstanceIdentifier<Node> nodeIdent, ReadWriteTransaction tx) {
        Preconditions.checkNotNull(groupStats);
        Preconditions.checkNotNull(nodeIdent);
        Preconditions.checkNotNull((Object)tx);
        InstanceIdentifier fNodeIdent = nodeIdent.augmentation(FlowCapableNode.class);
        for (GroupStats gStat : groupStats) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.statistics.GroupStatistics stats = new GroupStatisticsBuilder((GroupStatistics)gStat).build();
            KeyedInstanceIdentifier groupIdent = fNodeIdent.child(Group.class, (Identifier)new GroupKey(gStat.getGroupId()));
            InstanceIdentifier nGroupStatIdent = groupIdent.augmentation(NodeGroupStatistics.class);
            InstanceIdentifier gsIdent = nGroupStatIdent.child(org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.statistics.GroupStatistics.class);
            Optional group = Optional.absent();
            try {
                group = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)groupIdent).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("Read Operational/DS for Group node fail! {}", (Object)groupIdent, (Object)e);
            }
            if (!group.isPresent()) continue;
            tx.merge(LogicalDatastoreType.OPERATIONAL, nGroupStatIdent, (DataObject)new NodeGroupStatisticsBuilder().build(), true);
            tx.put(LogicalDatastoreType.OPERATIONAL, gsIdent, (DataObject)stats);
        }
    }

    private void statGroupDescCommit(Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer, ReadWriteTransaction tx, InstanceIdentifier<FlowCapableNode> fNodeIdent, List<GroupKey> existGroupKeys) {
        List groupStats;
        TransactionAware notif;
        Preconditions.checkNotNull(existGroupKeys);
        Preconditions.checkNotNull(txContainer);
        Preconditions.checkNotNull(fNodeIdent);
        Preconditions.checkNotNull((Object)tx);
        List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
        Iterator i$ = cacheNotifs.iterator();
        while (i$.hasNext() && (notif = (TransactionAware)i$.next()) instanceof GroupDescStatsUpdated && (groupStats = ((GroupDescStatsUpdated)notif).getGroupDescStats()) != null) {
            for (GroupDescStats group : groupStats) {
                if (group.getGroupId() == null) continue;
                GroupBuilder groupBuilder = new GroupBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)group);
                GroupKey groupKey = new GroupKey(group.getGroupId());
                KeyedInstanceIdentifier groupRef = fNodeIdent.child(Group.class, (Identifier)groupKey);
                NodeGroupDescStatsBuilder groupDesc = new NodeGroupDescStatsBuilder();
                groupDesc.setGroupDesc(new GroupDescBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)group).build());
                groupBuilder.addAugmentation(NodeGroupDescStats.class, (Augmentation)groupDesc.build());
                existGroupKeys.remove(groupKey);
                tx.put(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)groupRef, (DataObject)groupBuilder.build());
            }
        }
    }

    private void deleteAllNotPresentNode(InstanceIdentifier<FlowCapableNode> fNodeIdent, ReadWriteTransaction trans, List<GroupKey> deviceGroupKeys) {
        Preconditions.checkNotNull(fNodeIdent);
        Preconditions.checkNotNull((Object)trans);
        if (deviceGroupKeys == null) {
            return;
        }
        for (GroupKey key : deviceGroupKeys) {
            KeyedInstanceIdentifier delGroupIdent = fNodeIdent.child(Group.class, (Identifier)key);
            LOG.trace("Group {} has to removed.", (Object)key);
            Optional delGroup = Optional.absent();
            try {
                delGroup = (Optional)trans.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)delGroupIdent).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("Group {} was probably deleted via other transaction. Exception {}", (Object)delGroupIdent, (Object)e);
            }
            if (!delGroup.isPresent()) continue;
            trans.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)delGroupIdent);
        }
    }
}

