/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractListenCommit;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.FlowComparator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowHashIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowHashIdMappingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table.FlowHashIdMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table.FlowHashIdMapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table.FlowHashIdMapKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowsStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.aggregate.flow.statistics.AggregateFlowStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.and.statistics.map.list.FlowAndStatisticsMapList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.and.statistics.map.list.FlowAndStatisticsMapListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.statistics.FlowStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.AggregateFlowStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.GenericStatistics;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatListenCommitFlow
extends StatAbstractListenCommit<Flow, OpendaylightFlowStatisticsListener>
implements OpendaylightFlowStatisticsListener {
    protected static final Logger LOG = LoggerFactory.getLogger(StatListenCommitFlow.class);
    private static final String ALIEN_SYSTEM_FLOW_ID = "#UF$TABLE*";
    private static final Integer REMOVE_AFTER_MISSING_COLLECTION = 1;
    private static final int TRUNCATED_LOG_MESSAGE_LENGTH = 30;
    private final AtomicInteger unaccountedFlowsCounter = new AtomicInteger(0);

    public StatListenCommitFlow(StatisticsManager manager, DataBroker db, NotificationProviderService nps, StatNodeRegistration nrm) {
        super(manager, db, nps, Flow.class, nrm);
    }

    @Override
    protected OpendaylightFlowStatisticsListener getStatNotificationListener() {
        return this;
    }

    @Override
    protected InstanceIdentifier<Flow> getWildCardedRegistrationPath() {
        return InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(Table.class).child(Flow.class);
    }

    public void onAggregateFlowStatisticsUpdate(final AggregateFlowStatisticsUpdate notification) {
        NodeId nodeId;
        final TransactionId transId = notification.getTransactionId();
        if (!this.isExpectedStatistics(transId, nodeId = notification.getId())) {
            LOG.debug("STAT-MANAGER - AggregateFlowStatisticsUpdate: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitFlow.this.getTransactionCacheContainer(transId, nodeId);
                if (!txContainer.isPresent() || ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications() == null) {
                    return;
                }
                Optional<DataObject> inputObj = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getConfInput();
                if (!inputObj.isPresent() || !(inputObj.get() instanceof Table)) {
                    return;
                }
                if (!StatListenCommitFlow.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                Table table = (Table)inputObj.get();
                List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                for (TransactionAware notif : cacheNotifs) {
                    if (!(notif instanceof AggregateFlowStatisticsUpdate)) continue;
                    AggregateFlowStatisticsData stats = new AggregateFlowStatisticsDataBuilder().setAggregateFlowStatistics(new AggregateFlowStatisticsBuilder((AggregateFlowStatistics)notification).build()).build();
                    InstanceIdentifier fNodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId)).augmentation(FlowCapableNode.class);
                    KeyedInstanceIdentifier tableRef = fNodeIdent.child(Table.class, (Identifier)table.getKey());
                    InstanceIdentifier tableStatRef = tableRef.augmentation(AggregateFlowStatisticsData.class);
                    Optional fNode = Optional.absent();
                    try {
                        fNode = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, fNodeIdent).checkedGet();
                    }
                    catch (ReadFailedException e) {
                        LOG.debug("Read Operational/DS for FlowCapableNode fail! {}", (Object)fNodeIdent, (Object)e);
                        return;
                    }
                    if (!fNode.isPresent()) continue;
                    StatListenCommitFlow.this.ensureTable(tx, table.getId(), (InstanceIdentifier<Table>)tableRef);
                    tx.put(LogicalDatastoreType.OPERATIONAL, tableStatRef, (DataObject)stats);
                }
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitFlow.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    public void ensureTable(ReadWriteTransaction tx, Short tableId, InstanceIdentifier<Table> tableRef) {
        Table tableNew = new TableBuilder().setId(tableId).build();
        tx.merge(LogicalDatastoreType.OPERATIONAL, tableRef, (DataObject)tableNew);
    }

    public void onFlowsStatisticsUpdate(FlowsStatisticsUpdate notification) {
        NodeId nodeId;
        final TransactionId transId = notification.getTransactionId();
        if (!this.isExpectedStatistics(transId, nodeId = notification.getId())) {
            LOG.debug("STAT-MANAGER - FlowsStatisticsUpdate: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            LOG.trace("Next notification for join txId {}", (Object)transId);
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction tx) {
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatListenCommitFlow.this.getTransactionCacheContainer(transId, nodeId);
                if (!txContainer.isPresent() || ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications() == null) {
                    return;
                }
                if (!StatListenCommitFlow.this.nodeRegistrationManager.isFlowCapableNodeOwner(nodeId)) {
                    return;
                }
                ArrayList flowStats = new ArrayList(10);
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                List cacheNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                for (TransactionAware notif : cacheNotifs) {
                    List list;
                    if (!(notif instanceof FlowsStatisticsUpdate) || (list = ((FlowsStatisticsUpdate)notif).getFlowAndStatisticsMapList()) == null) continue;
                    flowStats.addAll(list);
                }
                StatListenCommitFlow.this.statsFlowCommitAll(flowStats, (InstanceIdentifier<Node>)((InstanceIdentifier)nodeIdent), tx);
                Map listAliens = (Map)StatListenCommitFlow.this.mapNodesForDelete.get(nodeIdent);
                if (listAliens != null) {
                    for (Map.Entry entry : listAliens.entrySet()) {
                        Integer lifeIndex = (Integer)entry.getValue();
                        if ((Integer)entry.getValue() > 0) {
                            entry.setValue(lifeIndex - 1);
                            continue;
                        }
                        InstanceIdentifier flowNodeIdent = (InstanceIdentifier)entry.getKey();
                        ((Map)StatListenCommitFlow.this.mapNodesForDelete.get(nodeIdent)).remove(flowNodeIdent);
                        tx.delete(LogicalDatastoreType.OPERATIONAL, flowNodeIdent);
                    }
                }
                StatListenCommitFlow.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)nodeIdent, transId);
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatListenCommitFlow.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    private void statsFlowCommitAll(List<FlowAndStatisticsMapList> list, InstanceIdentifier<Node> nodeIdent, ReadWriteTransaction tx) {
        Optional fNode;
        InstanceIdentifier fNodeIdent = nodeIdent.augmentation(FlowCapableNode.class);
        try {
            fNode = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, fNodeIdent).checkedGet();
        }
        catch (ReadFailedException e) {
            LOG.debug("Read FlowCapableNode {} in Operational/DS fail! Statistic scan not be updated.", nodeIdent, (Object)e);
            return;
        }
        if (!fNode.isPresent()) {
            LOG.trace("FlowCapableNode {} is not presented in Operational/DS. Statisticscan not be updated.", nodeIdent);
            return;
        }
        NodeUpdateState nodeState = new NodeUpdateState((InstanceIdentifier<FlowCapableNode>)fNodeIdent, (FlowCapableNode)fNode.get());
        for (FlowAndStatisticsMapList flowStat : list) {
            TableKey tableKey = new TableKey(flowStat.getTableId());
            TableFlowUpdateState tableState = nodeState.getTable(tableKey, tx);
            tableState.reportFlow(flowStat, tx);
        }
        for (TableFlowUpdateState table : nodeState.getTables()) {
            table.removeUnreportedFlows(tx);
        }
    }

    private void addStatistics(FlowBuilder flowBuilder, FlowAndStatisticsMapList deviceFlow) {
        FlowAndStatisticsMapListBuilder stats = new FlowAndStatisticsMapListBuilder(deviceFlow);
        FlowStatisticsBuilder flowStatisticsBuilder = new FlowStatisticsBuilder((GenericStatistics)stats.build());
        FlowStatisticsDataBuilder flowStatisticsData = new FlowStatisticsDataBuilder();
        flowStatisticsData.setFlowStatistics(flowStatisticsBuilder.build());
        flowBuilder.addAugmentation(FlowStatisticsData.class, (Augmentation)flowStatisticsData.build());
    }

    static String buildFlowIdOperKey(FlowAndStatisticsMapList deviceFlow) {
        return "" + deviceFlow.getMatch() + deviceFlow.getPriority() + deviceFlow.getCookie().getValue();
    }

    private class TableFlowUpdateState {
        private boolean tableEnsured = false;
        final KeyedInstanceIdentifier<Table, TableKey> tableRef;
        final TableKey tableKey;
        final BiMap<FlowHashIdMapKey, FlowId> flowIdByHash;
        List<Flow> configFlows;

        public TableFlowUpdateState(KeyedInstanceIdentifier<Table, TableKey> tablePath, Table table) {
            FlowHashIdMapping flowHashMapping;
            this.tableRef = tablePath;
            this.tableKey = (TableKey)tablePath.getKey();
            this.flowIdByHash = HashBiMap.create();
            if (table != null && (flowHashMapping = (FlowHashIdMapping)table.getAugmentation(FlowHashIdMapping.class)) != null) {
                List flowHashMap = flowHashMapping.getFlowHashIdMap() != null ? flowHashMapping.getFlowHashIdMap() : Collections.emptyList();
                for (FlowHashIdMap flowHashId : flowHashMap) {
                    try {
                        this.flowIdByHash.put((Object)flowHashId.getKey(), (Object)flowHashId.getFlowId());
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            FlowId currData = (FlowId)this.flowIdByHash.get((Object)flowHashId.getKey());
                            LOG.debug("flow hashing hit a duplicate for {} -> {}. Curr value: {} Equals:{}. Exception was raised:", new Object[]{flowHashId.getKey(), flowHashId.getFlowId(), currData, flowHashId.getFlowId().equals((Object)currData), e});
                            continue;
                        }
                        LOG.warn("flow hashing hit a duplicate {}. Exception was raised: {}. Enable DEBUG for more detail.", (Object)flowHashId.getFlowId().toString().substring(0, Math.min(30, flowHashId.getFlowId().toString().length())), (Object)e.getMessage().substring(0, Math.min(30, e.getMessage().length())));
                    }
                }
            }
        }

        private void ensureTableFowHashIdMapping(ReadWriteTransaction tx) {
            if (!this.tableEnsured) {
                StatListenCommitFlow.this.ensureTable(tx, this.tableKey.getId(), (InstanceIdentifier<Table>)this.tableRef);
                FlowHashIdMapping emptyMapping = new FlowHashIdMappingBuilder().setFlowHashIdMap(Collections.emptyList()).build();
                tx.merge(LogicalDatastoreType.OPERATIONAL, this.tableRef.augmentation(FlowHashIdMapping.class), (DataObject)emptyMapping);
                this.tableEnsured = true;
            }
        }

        private FlowKey searchInConfiguration(FlowAndStatisticsMapList flowStat, ReadWriteTransaction trans) {
            this.initConfigFlows();
            for (Flow cfgFlow : this.configFlows) {
                FlowKey cfgKey = cfgFlow.getKey();
                FlowId cfgFlowId = cfgKey.getId();
                if (this.flowIdByHash.inverse().containsKey((Object)cfgFlowId) || !FlowComparator.flowEquals((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)flowStat, (org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)cfgFlow)) continue;
                return cfgKey;
            }
            return null;
        }

        private void initConfigFlows() {
            Optional table = StatListenCommitFlow.this.readLatestConfiguration(this.tableRef);
            List localList = null;
            if (table.isPresent()) {
                localList = ((Table)table.get()).getFlow();
            }
            this.configFlows = localList == null ? Collections.emptyList() : new ArrayList<Flow>(localList);
        }

        private FlowKey getFlowKeyAndRemoveHash(FlowHashIdMapKey key) {
            FlowId ret = (FlowId)this.flowIdByHash.get((Object)key);
            if (ret != null) {
                this.flowIdByHash.remove((Object)key);
                return new FlowKey(ret);
            }
            return null;
        }

        private FlowKey makeAlienFlowKey() {
            StringBuilder sBuilder = new StringBuilder(StatListenCommitFlow.ALIEN_SYSTEM_FLOW_ID).append(this.tableKey.getId()).append("-").append(StatListenCommitFlow.this.unaccountedFlowsCounter.incrementAndGet());
            FlowId flowId = new FlowId(sBuilder.toString());
            return new FlowKey(flowId);
        }

        private Map<FlowHashIdMapKey, FlowId> getRemovalList() {
            return this.flowIdByHash;
        }

        void reportFlow(FlowAndStatisticsMapList flowStat, ReadWriteTransaction trans) {
            this.ensureTableFowHashIdMapping(trans);
            FlowHashIdMapKey hashingKey = new FlowHashIdMapKey(StatListenCommitFlow.buildFlowIdOperKey(flowStat));
            FlowKey flowKey = this.getFlowKeyAndRemoveHash(hashingKey);
            if (flowKey == null) {
                flowKey = this.searchInConfiguration(flowStat, trans);
                if (flowKey == null) {
                    flowKey = this.makeAlienFlowKey();
                }
                this.updateHashCache(trans, flowKey, hashingKey);
            }
            FlowBuilder flowBuilder = new FlowBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow)flowStat);
            flowBuilder.setKey(flowKey);
            StatListenCommitFlow.this.addStatistics(flowBuilder, flowStat);
            KeyedInstanceIdentifier flowIdent = this.tableRef.child(Flow.class, (Identifier)flowKey);
            trans.put(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)flowIdent, (DataObject)flowBuilder.build());
            if (flowKey.getId().getValue().startsWith(StatListenCommitFlow.ALIEN_SYSTEM_FLOW_ID)) {
                StatListenCommitFlow.this.removeData((InstanceIdentifier<?>)flowIdent, REMOVE_AFTER_MISSING_COLLECTION);
            }
        }

        private void updateHashCache(ReadWriteTransaction trans, FlowKey flowKey, FlowHashIdMapKey hashingKey) {
            FlowHashIdMapBuilder flHashIdMap = new FlowHashIdMapBuilder();
            flHashIdMap.setFlowId(flowKey.getId());
            flHashIdMap.setKey(hashingKey);
            KeyedInstanceIdentifier flHashIdent = this.tableRef.augmentation(FlowHashIdMapping.class).child(FlowHashIdMap.class, (Identifier)hashingKey);
            trans.put(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)flHashIdent, (DataObject)flHashIdMap.build());
        }

        void removeUnreportedFlows(ReadWriteTransaction tx) {
            InstanceIdentifier nodeIdent = this.tableRef.firstIdentifierOf(Node.class);
            List<InstanceIdentifier<Flow>> listMissingConfigFlows = this.notStatReportedConfigFlows();
            Map nodeDeleteMap = (Map)StatListenCommitFlow.this.mapNodesForDelete.get(nodeIdent);
            Map<FlowHashIdMapKey, FlowId> listForRemove = this.getRemovalList();
            for (Map.Entry<FlowHashIdMapKey, FlowId> entryForRemove : listForRemove.entrySet()) {
                FlowKey flowKey = new FlowKey(entryForRemove.getValue());
                KeyedInstanceIdentifier flowRef = this.tableRef.child(Flow.class, (Identifier)flowKey);
                if (nodeDeleteMap != null && flowKey.getId().getValue().startsWith(StatListenCommitFlow.ALIEN_SYSTEM_FLOW_ID)) {
                    Integer lifeIndex = (Integer)nodeDeleteMap.get(flowRef);
                    if (lifeIndex != null && lifeIndex > 0) break;
                    nodeDeleteMap.remove(flowRef);
                } else if (listMissingConfigFlows.remove(flowRef)) break;
                KeyedInstanceIdentifier flHashIdent = this.tableRef.augmentation(FlowHashIdMapping.class).child(FlowHashIdMap.class, (Identifier)entryForRemove.getKey());
                tx.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)flowRef);
                tx.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)flHashIdent);
            }
        }

        List<InstanceIdentifier<Flow>> notStatReportedConfigFlows() {
            if (this.configFlows != null) {
                ArrayList<InstanceIdentifier<Flow>> returnList = new ArrayList<InstanceIdentifier<Flow>>(this.configFlows.size());
                for (Flow confFlow : this.configFlows) {
                    KeyedInstanceIdentifier confFlowIdent = this.tableRef.child(Flow.class, (Identifier)confFlow.getKey());
                    returnList.add((InstanceIdentifier<Flow>)confFlowIdent);
                }
                return returnList;
            }
            return Collections.emptyList();
        }
    }

    private class NodeUpdateState {
        private final InstanceIdentifier<FlowCapableNode> nodeIdentifier;
        private final Map<TableKey, TableFlowUpdateState> tables = new HashMap<TableKey, TableFlowUpdateState>();

        public NodeUpdateState(InstanceIdentifier<FlowCapableNode> fNodeIdent, FlowCapableNode flowCapableNode) {
            this.nodeIdentifier = fNodeIdent;
            List tableList = flowCapableNode.getTable();
            if (tableList != null) {
                for (Table table : tableList) {
                    TableKey tableKey = table.getKey();
                    this.tables.put(tableKey, new TableFlowUpdateState((KeyedInstanceIdentifier<Table, TableKey>)this.nodeIdentifier.child(Table.class, (Identifier)tableKey), table));
                }
            }
        }

        public Iterable<TableFlowUpdateState> getTables() {
            return this.tables.values();
        }

        TableFlowUpdateState getTable(TableKey key, ReadWriteTransaction tx) {
            TableFlowUpdateState table = this.tables.get(key);
            if (table == null) {
                table = new TableFlowUpdateState((KeyedInstanceIdentifier<Table, TableKey>)this.nodeIdentifier.child(Table.class, (Identifier)key), null);
                this.tables.put(key, table);
            }
            return table;
        }
    }
}

