/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatListeningCommiter;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractNotifyCommit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatAbstractListenCommit<T extends DataObject, N extends NotificationListener>
extends StatAbstractNotifyCommit<N>
implements StatListeningCommiter<T, N> {
    private static final Logger LOG = LoggerFactory.getLogger(StatAbstractListenCommit.class);
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    protected final Map<InstanceIdentifier<Node>, Map<InstanceIdentifier<T>, Integer>> mapNodesForDelete = new ConcurrentHashMap<InstanceIdentifier<Node>, Map<InstanceIdentifier<T>, Integer>>();
    protected final Map<InstanceIdentifier<Node>, Integer> mapNodeFeautureRepeater = new ConcurrentHashMap<InstanceIdentifier<Node>, Integer>();
    private final Class<T> clazz;
    private final DataBroker dataBroker;
    protected final StatNodeRegistration nodeRegistrationManager;
    private ReadOnlyTransaction currentReadTx;
    private volatile boolean currentReadTxStale;

    public StatAbstractListenCommit(StatisticsManager manager, DataBroker db, NotificationProviderService nps, Class<T> clazz, StatNodeRegistration nodeRegistrationManager) {
        super(manager, nps, nodeRegistrationManager);
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"Referenced Class can not be null");
        Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"DataBroker can not be null!");
        this.listenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, this.getWildCardedRegistrationPath(), (DataChangeListener)this, AsyncDataBroker.DataChangeScope.BASE);
        this.dataBroker = db;
        this.nodeRegistrationManager = nodeRegistrationManager;
    }

    protected abstract InstanceIdentifier<T> getWildCardedRegistrationPath();

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> changeEvent) {
        Preconditions.checkNotNull(changeEvent, (Object)"Async ChangeEvent can not be null!");
        this.currentReadTxStale = true;
    }

    protected void removeData(InstanceIdentifier<?> key, Integer value) {
        if (this.clazz.equals(key.getTargetType())) {
            InstanceIdentifier nodeIdent = key.firstIdentifierOf(Node.class);
            Map<InstanceIdentifier<T>, Integer> map = null;
            if (this.mapNodesForDelete.containsKey(nodeIdent)) {
                map = this.mapNodesForDelete.get(nodeIdent);
            }
            if (map == null) {
                map = new ConcurrentHashMap<InstanceIdentifier<T>, Integer>();
                this.mapNodesForDelete.put((InstanceIdentifier<Node>)nodeIdent, map);
            }
            map.put(key, value);
        }
    }

    @Override
    public void cleanForDisconnect(InstanceIdentifier<Node> nodeIdent) {
        this.mapNodesForDelete.remove(nodeIdent);
    }

    @Override
    public void close() {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error by stop {} DataChange StatListeningCommiter.", (Object)this.clazz.getSimpleName(), (Object)e);
            }
            this.listenerRegistration = null;
        }
        super.close();
    }

    protected final <K extends DataObject> Optional<K> readLatestConfiguration(InstanceIdentifier<K> path) {
        for (int i = 0; i < 2; ++i) {
            boolean localReadTxStale = this.currentReadTxStale;
            ReadOnlyTransaction localReadTx = this.currentReadTx;
            if (localReadTx == null || localReadTxStale) {
                if (localReadTx != null) {
                    localReadTx.close();
                }
                this.currentReadTx = localReadTx = this.dataBroker.newReadOnlyTransaction();
                this.currentReadTxStale = false;
            }
            try {
                return (Optional)localReadTx.read(LogicalDatastoreType.CONFIGURATION, path).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("It wasn't possible to read {} from datastore. Exception: {}", path, (Object)e);
                this.currentReadTxStale = true;
                continue;
            }
        }
        return Optional.absent();
    }
}

