/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.config.yang.statistics_manager;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.openflowplugin.applications.config.yang.statistics_manager.AbstractStatisticsManagerModule;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatisticsManagerConfig;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatisticsManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsManagerModule
extends AbstractStatisticsManagerModule {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsManagerModule.class);
    private static final int MAX_NODES_FOR_COLLECTOR_DEFAULT = 16;
    private static final int MIN_REQUEST_NET_MONITOR_INTERVAL_DEFAULT = 3000;

    public StatisticsManagerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public StatisticsManagerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, StatisticsManagerModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
    }

    public AutoCloseable createInstance() {
        LOG.info("StatisticsManager module initialization.");
        StatisticsManagerConfig config = this.createConfig();
        StatisticsManagerImpl statisticsManagerProvider = new StatisticsManagerImpl(this.getDataBrokerDependency(), config);
        statisticsManagerProvider.setOwnershipService(this.getOwnershipServiceDependency());
        statisticsManagerProvider.start(this.getNotificationServiceDependency(), (RpcConsumerRegistry)this.getRpcRegistryDependency());
        final StatisticsManagerImpl statisticsManagerProviderExposed = statisticsManagerProvider;
        LOG.info("StatisticsManager started successfully.");
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                try {
                    statisticsManagerProviderExposed.close();
                }
                catch (Exception e) {
                    LOG.error("Unexpected error by stopping StatisticsManager module", (Throwable)e);
                }
                LOG.info("StatisticsManager module stopped.");
            }
        };
    }

    private StatisticsManagerConfig createConfig() {
        StatisticsManagerConfig.StatisticsManagerConfigBuilder builder = StatisticsManagerConfig.builder();
        if (this.getStatisticsManagerSettings() != null && this.getStatisticsManagerSettings().getMaxNodesForCollector() != null) {
            builder.setMaxNodesForCollector(this.getStatisticsManagerSettings().getMaxNodesForCollector());
        } else {
            LOG.warn("Load the xml ConfigSubsystem input value fail! MaxNodesForCollector value is set to {} ", (Object)16);
            builder.setMaxNodesForCollector(16);
        }
        if (this.getStatisticsManagerSettings() != null && this.getStatisticsManagerSettings().getMinRequestNetMonitorInterval() != null) {
            builder.setMinRequestNetMonitorInterval(this.getStatisticsManagerSettings().getMinRequestNetMonitorInterval());
        } else {
            LOG.warn("Load the xml CofnigSubsystem input value fail! MinRequestNetMonitorInterval value is set to {} ", (Object)3000);
            builder.setMinRequestNetMonitorInterval(3000);
        }
        return builder.build();
    }
}

