/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.IntegerIpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.MacAddressFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv6Match;

public class MatchComparatorHelper {
    private static final int DEFAULT_SUBNET = 32;
    private static final int IPV4_MASK_LENGTH = 32;
    private static final int SHIFT_OCTET_1 = 24;
    private static final int SHIFT_OCTET_2 = 16;
    private static final int SHIFT_OCTET_3 = 8;
    private static final int SHIFT_OCTET_4 = 0;
    private static final int POSITION_OCTET_1 = 0;
    private static final int POSITION_OCTET_2 = 1;
    private static final int POSITION_OCTET_3 = 2;
    private static final int POSITION_OCTET_4 = 3;

    @VisibleForTesting
    static boolean ethernetMatchEquals(EthernetMatch statsEthernetMatch, EthernetMatch storedEthernetMatch) {
        boolean verdict = true;
        Boolean checkNullValues = MatchComparatorHelper.checkNullValues(statsEthernetMatch, storedEthernetMatch);
        if (checkNullValues != null) {
            verdict = checkNullValues;
        } else {
            verdict = MatchComparatorHelper.ethernetMatchFieldsEquals((MacAddressFilter)statsEthernetMatch.getEthernetSource(), (MacAddressFilter)storedEthernetMatch.getEthernetSource());
            if (verdict) {
                verdict = MatchComparatorHelper.ethernetMatchFieldsEquals((MacAddressFilter)statsEthernetMatch.getEthernetDestination(), (MacAddressFilter)storedEthernetMatch.getEthernetDestination());
            }
            if (verdict) {
                if (statsEthernetMatch.getEthernetType() == null) {
                    if (storedEthernetMatch.getEthernetType() != null) {
                        verdict = false;
                    }
                } else {
                    verdict = statsEthernetMatch.getEthernetType().equals(storedEthernetMatch.getEthernetType());
                }
            }
        }
        return verdict;
    }

    static boolean ethernetMatchFieldsEquals(MacAddressFilter statsEthernetMatchFields, MacAddressFilter storedEthernetMatchFields) {
        boolean verdict = true;
        Boolean checkNullValues = MatchComparatorHelper.checkNullValues(statsEthernetMatchFields, storedEthernetMatchFields);
        if (checkNullValues != null) {
            verdict = checkNullValues;
        } else {
            verdict = MatchComparatorHelper.macAddressEquals(statsEthernetMatchFields.getAddress(), storedEthernetMatchFields.getAddress());
            if (verdict) {
                verdict = MatchComparatorHelper.macAddressEquals(statsEthernetMatchFields.getMask(), storedEthernetMatchFields.getMask());
            }
        }
        return verdict;
    }

    static boolean macAddressEquals(MacAddress statsMacAddress, MacAddress storedMacAddress) {
        boolean verdict = true;
        Boolean checkNullValues = MatchComparatorHelper.checkNullValues(statsMacAddress, storedMacAddress);
        verdict = checkNullValues != null ? checkNullValues.booleanValue() : statsMacAddress.getValue().equalsIgnoreCase(storedMacAddress.getValue());
        return verdict;
    }

    @VisibleForTesting
    static boolean layer3MatchEquals(Layer3Match statsLayer3Match, Layer3Match storedLayer3Match) {
        boolean verdict = true;
        if (statsLayer3Match instanceof Ipv4Match && storedLayer3Match instanceof Ipv4Match) {
            Ipv4Match statsIpv4Match = (Ipv4Match)statsLayer3Match;
            Ipv4Match storedIpv4Match = (Ipv4Match)storedLayer3Match;
            verdict = MatchComparatorHelper.compareIpv4PrefixNullSafe(storedIpv4Match.getIpv4Destination(), statsIpv4Match.getIpv4Destination());
            if (verdict) {
                verdict = MatchComparatorHelper.compareIpv4PrefixNullSafe(statsIpv4Match.getIpv4Source(), storedIpv4Match.getIpv4Source());
            }
        } else if (statsLayer3Match instanceof Ipv6Match && storedLayer3Match instanceof Ipv6Match) {
            Ipv6Match statsIpv6Match = (Ipv6Match)statsLayer3Match;
            Ipv6Match storedIpv6Match = (Ipv6Match)storedLayer3Match;
            verdict = MatchComparatorHelper.compareIpv6PrefixNullSafe(storedIpv6Match.getIpv6Destination(), statsIpv6Match.getIpv6Destination());
            if (verdict) {
                verdict = MatchComparatorHelper.compareIpv6PrefixNullSafe(statsIpv6Match.getIpv6Source(), storedIpv6Match.getIpv6Source());
            }
        } else {
            Boolean nullCheckOut = MatchComparatorHelper.checkNullValues(storedLayer3Match, statsLayer3Match);
            verdict = nullCheckOut != null ? nullCheckOut.booleanValue() : storedLayer3Match.equals(statsLayer3Match);
        }
        return verdict;
    }

    static boolean IpAddressEquals(Ipv4Prefix statsIpAddress, Ipv4Prefix storedIpAddress) {
        IntegerIpAddress storedIpAddressInt;
        IntegerIpAddress statsIpAddressInt = MatchComparatorHelper.strIpToIntIp(statsIpAddress.getValue());
        if (MatchComparatorHelper.ipAndMaskBasedMatch(statsIpAddressInt, storedIpAddressInt = MatchComparatorHelper.strIpToIntIp(storedIpAddress.getValue()))) {
            return true;
        }
        return MatchComparatorHelper.ipBasedMatch(statsIpAddressInt, storedIpAddressInt);
    }

    static boolean ipAndMaskBasedMatch(IntegerIpAddress statsIpAddressInt, IntegerIpAddress storedIpAddressInt) {
        return (statsIpAddressInt.getIp() & statsIpAddressInt.getMask()) == (storedIpAddressInt.getIp() & storedIpAddressInt.getMask());
    }

    static boolean ipBasedMatch(IntegerIpAddress statsIpAddressInt, IntegerIpAddress storedIpAddressInt) {
        return statsIpAddressInt.getIp() == storedIpAddressInt.getIp();
    }

    private static boolean IpAddressEquals(Ipv6Prefix statsIpv6, Ipv6Prefix storedIpv6) {
        String[] statsIpMask = statsIpv6.getValue().split("/");
        String[] storedIpMask = storedIpv6.getValue().split("/");
        if (statsIpMask.length <= 1 || storedIpMask.length <= 1 || !statsIpMask[1].equals(storedIpMask[1])) {
            return false;
        }
        return InetAddresses.forString((String)statsIpMask[0]).equals(InetAddresses.forString((String)storedIpMask[0]));
    }

    static Boolean checkNullValues(Object v1, Object v2) {
        Boolean verdict = null;
        if (v1 == null && v2 != null) {
            verdict = Boolean.FALSE;
        } else if (v1 != null && v2 == null) {
            verdict = Boolean.FALSE;
        } else if (v1 == null && v2 == null) {
            verdict = Boolean.TRUE;
        }
        return verdict;
    }

    static boolean compareIpv4PrefixNullSafe(Ipv4Prefix statsIpv4, Ipv4Prefix storedIpv4) {
        boolean verdict = true;
        Boolean checkDestNullValuesOut = MatchComparatorHelper.checkNullValues(storedIpv4, statsIpv4);
        if (checkDestNullValuesOut != null) {
            verdict = checkDestNullValuesOut;
        } else if (!MatchComparatorHelper.IpAddressEquals(statsIpv4, storedIpv4)) {
            verdict = false;
        }
        return verdict;
    }

    private static boolean compareIpv6PrefixNullSafe(Ipv6Prefix statsIpv6, Ipv6Prefix storedIpv6) {
        boolean verdict = true;
        Boolean checkDestNullValuesOut = MatchComparatorHelper.checkNullValues(statsIpv6, storedIpv6);
        if (checkDestNullValuesOut != null) {
            verdict = checkDestNullValuesOut;
        } else if (!MatchComparatorHelper.IpAddressEquals(statsIpv6, storedIpv6)) {
            verdict = false;
        }
        return verdict;
    }

    static IntegerIpAddress strIpToIntIp(String ipAddresss) {
        int prefix;
        String[] parts = ipAddresss.split("/");
        String ip = parts[0];
        if (parts.length < 2) {
            prefix = 32;
        } else {
            prefix = Integer.parseInt(parts[1]);
            if (prefix < 0 || prefix > 32) {
                StringBuilder stringBuilder = new StringBuilder("Valid values for mask are from range 0 - 32. Value ");
                stringBuilder.append(prefix);
                stringBuilder.append(" is invalid.");
                throw new IllegalStateException(stringBuilder.toString());
            }
        }
        IntegerIpAddress integerIpAddress = null;
        Inet4Address addr = (Inet4Address)InetAddresses.forString((String)ip);
        byte[] addrBytes = addr.getAddress();
        int ipInt = (addrBytes[0] & 0xFF) << 24 | (addrBytes[1] & 0xFF) << 16 | (addrBytes[2] & 0xFF) << 8 | (addrBytes[3] & 0xFF) << 0;
        int mask = -1 << 32 - prefix;
        integerIpAddress = new IntegerIpAddress(ipInt, mask);
        return integerIpAddress;
    }
}

