/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractNotifyCommit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.and.statistics.map.FlowTableAndStatisticsMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.statistics.FlowTableStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.statistics.FlowTableStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.GenericTableStatistics;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatNotifyCommitTable
extends StatAbstractNotifyCommit<OpendaylightFlowTableStatisticsListener>
implements OpendaylightFlowTableStatisticsListener {
    private static final Logger LOG = LoggerFactory.getLogger(StatNotifyCommitTable.class);

    public StatNotifyCommitTable(StatisticsManager manager, NotificationProviderService nps) {
        super(manager, nps);
    }

    @Override
    protected OpendaylightFlowTableStatisticsListener getStatNotificationListener() {
        return this;
    }

    public void onFlowTableStatisticsUpdate(FlowTableStatisticsUpdate notification) {
        NodeId nodeId;
        final TransactionId transId = notification.getTransactionId();
        if (!this.isExpectedStatistics(transId, nodeId = notification.getId())) {
            LOG.debug("STAT-MANAGER - FlowTableStatisticsUpdate: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId){

            @Override
            public void applyOperation(ReadWriteTransaction trans) {
                ArrayList tableStats = new ArrayList(10);
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatNotifyCommitTable.this.getTransactionCacheContainer(transId, nodeId);
                KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
                if (!txContainer.isPresent() || ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNodeId() == null) {
                    return;
                }
                List cachedNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                for (TransactionAware notif : cachedNotifs) {
                    List statNotif;
                    if (!(notif instanceof FlowTableStatisticsUpdate) || (statNotif = ((FlowTableStatisticsUpdate)notif).getFlowTableAndStatisticsMap()) == null) continue;
                    tableStats.addAll(statNotif);
                }
                StatNotifyCommitTable.this.statTableCommit(tableStats, (InstanceIdentifier<Node>)((InstanceIdentifier)nodeIdent), trans);
                StatNotifyCommitTable.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)nodeIdent, transId);
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatNotifyCommitTable.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    private void statTableCommit(List<FlowTableAndStatisticsMap> tableStats, InstanceIdentifier<Node> nodeIdent, ReadWriteTransaction trans) {
        InstanceIdentifier fNodeIdent = nodeIdent.augmentation(FlowCapableNode.class);
        Optional fNode = Optional.absent();
        try {
            fNode = (Optional)trans.read(LogicalDatastoreType.OPERATIONAL, fNodeIdent).checkedGet();
        }
        catch (ReadFailedException e) {
            LOG.debug("Read Operational/DS for FlowCapableNode fail! {}", (Object)fNodeIdent, (Object)e);
            return;
        }
        if (!fNode.isPresent()) {
            LOG.trace("Read Operational/DS for FlowCapableNode fail! Node {} doesn't exist.", (Object)fNodeIdent);
            return;
        }
        for (FlowTableAndStatisticsMap tableStat : tableStats) {
            KeyedInstanceIdentifier tableIdent = fNodeIdent.child(Table.class, (Identifier)new TableKey(tableStat.getTableId().getValue()));
            Table table = new TableBuilder().setId(tableStat.getTableId().getValue()).build();
            trans.merge(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)tableIdent, (DataObject)table);
            InstanceIdentifier tableStatIdent = tableIdent.augmentation(FlowTableStatisticsData.class);
            trans.merge(LogicalDatastoreType.OPERATIONAL, tableStatIdent, (DataObject)new FlowTableStatisticsDataBuilder().build());
            FlowTableStatistics stats = new FlowTableStatisticsBuilder((GenericTableStatistics)tableStat).build();
            InstanceIdentifier tStatIdent = tableStatIdent.child(FlowTableStatistics.class);
            trans.put(LogicalDatastoreType.OPERATIONAL, tStatIdent, (DataObject)stats);
        }
    }
}

