/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatRpcMsgManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.StatAbstractNotifyCommit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.NodeConnectorStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.FlowCapableNodeConnectorStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.FlowCapableNodeConnectorStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.NodeConnectorStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.flow.capable.node.connector.statistics.FlowCapableNodeConnectorStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.flow.capable.node.connector.statistics.FlowCapableNodeConnectorStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMap;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatNotifyCommitPort
extends StatAbstractNotifyCommit<OpendaylightPortStatisticsListener>
implements OpendaylightPortStatisticsListener {
    private static final Logger LOG = LoggerFactory.getLogger(StatNotifyCommitPort.class);

    public StatNotifyCommitPort(StatisticsManager manager, NotificationProviderService nps) {
        super(manager, nps);
    }

    @Override
    protected OpendaylightPortStatisticsListener getStatNotificationListener() {
        return this;
    }

    public void onNodeConnectorStatisticsUpdate(NodeConnectorStatisticsUpdate notification) {
        NodeId nodeId;
        final TransactionId transId = notification.getTransactionId();
        if (!this.isExpectedStatistics(transId, nodeId = notification.getId())) {
            LOG.debug("STAT-MANAGER - NodeConnectorStatisticsUpdate: unregistred notification detect TransactionId {}", (Object)transId);
            return;
        }
        this.manager.getRpcMsgManager().addNotification(notification, nodeId);
        if (notification.isMoreReplies().booleanValue()) {
            return;
        }
        KeyedInstanceIdentifier nodeIdent = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)new NodeKey(nodeId));
        this.manager.enqueue(new StatisticsManager.StatDataStoreOperation(StatisticsManager.StatDataStoreOperation.StatsManagerOperationType.DATA_COMMIT_OPER_DS, nodeId, (InstanceIdentifier)nodeIdent){
            final /* synthetic */ InstanceIdentifier val$nodeIdent;
            {
                this.val$nodeIdent = instanceIdentifier;
                super(x0, x1);
            }

            @Override
            public void applyOperation(ReadWriteTransaction trans) {
                Optional<StatRpcMsgManager.TransactionCacheContainer<?>> txContainer = StatNotifyCommitPort.this.getTransactionCacheContainer(transId, nodeId);
                if (!txContainer.isPresent() || ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications() == null) {
                    return;
                }
                ArrayList portStats = new ArrayList(10);
                List cachedNotifs = ((StatRpcMsgManager.TransactionCacheContainer)txContainer.get()).getNotifications();
                for (TransactionAware notif : cachedNotifs) {
                    List notifStat;
                    if (!(notif instanceof NodeConnectorStatisticsUpdate) || (notifStat = ((NodeConnectorStatisticsUpdate)notif).getNodeConnectorStatisticsAndPortNumberMap()) == null) continue;
                    portStats.addAll(notifStat);
                }
                StatNotifyCommitPort.this.statPortCommit(portStats, (InstanceIdentifier<Node>)this.val$nodeIdent, trans);
                StatNotifyCommitPort.this.notifyToCollectNextStatistics((InstanceIdentifier<Node>)this.val$nodeIdent, transId);
            }

            @Override
            public UUID generatedUUIDForNode() {
                return StatNotifyCommitPort.this.manager.getGeneratedUUIDForNode(this.getNodeIdentifier());
            }
        });
    }

    private void statPortCommit(List<NodeConnectorStatisticsAndPortNumberMap> portStats, InstanceIdentifier<Node> nodeIdent, ReadWriteTransaction tx) {
        Optional fNode = Optional.absent();
        try {
            fNode = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, nodeIdent).checkedGet();
        }
        catch (ReadFailedException e) {
            LOG.debug("Read Operational/DS for Node fail! {}", nodeIdent, (Object)e);
            return;
        }
        if (!fNode.isPresent()) {
            LOG.trace("Read Operational/DS for Node fail! Node {} doesn't exist.", nodeIdent);
            return;
        }
        for (NodeConnectorStatisticsAndPortNumberMap nConnectPort : portStats) {
            Optional fNodeConector;
            FlowCapableNodeConnectorStatistics stats = new FlowCapableNodeConnectorStatisticsBuilder((NodeConnectorStatistics)nConnectPort).build();
            NodeConnectorKey key = new NodeConnectorKey(nConnectPort.getNodeConnectorId());
            KeyedInstanceIdentifier nodeConnectorIdent = nodeIdent.child(NodeConnector.class, (Identifier)key);
            InstanceIdentifier nodeConnStatIdent = nodeConnectorIdent.augmentation(FlowCapableNodeConnectorStatisticsData.class);
            InstanceIdentifier flowCapNodeConnStatIdent = nodeConnStatIdent.child(FlowCapableNodeConnectorStatistics.class);
            try {
                fNodeConector = (Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeConnectorIdent).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.debug("Read NodeConnector {} in Operational/DS fail!", (Object)nodeConnectorIdent, (Object)e);
                fNodeConector = Optional.absent();
            }
            if (!fNodeConector.isPresent()) continue;
            tx.merge(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeConnectorIdent, (DataObject)new NodeConnectorBuilder().setId(key.getId()).build());
            tx.merge(LogicalDatastoreType.OPERATIONAL, nodeConnStatIdent, (DataObject)new FlowCapableNodeConnectorStatisticsDataBuilder().build());
            tx.put(LogicalDatastoreType.OPERATIONAL, flowCapNodeConnStatIdent, (DataObject)stats);
        }
    }
}

