/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.rev140925.modules.module.configuration.statistics.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.app.statistics.manager.rev140925.modules.module.configuration.statistics.manager.StatisticsManagerSettings;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatisticsManagerSettingsBuilder
implements Builder<StatisticsManagerSettings> {
    private Integer _maxNodesForCollector;
    private Integer _minRequestNetMonitorInterval;
    Map<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>> augmentation = Collections.emptyMap();

    public StatisticsManagerSettingsBuilder() {
    }

    public StatisticsManagerSettingsBuilder(StatisticsManagerSettings base) {
        AugmentationHolder casted;
        this._maxNodesForCollector = base.getMaxNodesForCollector();
        this._minRequestNetMonitorInterval = base.getMinRequestNetMonitorInterval();
        if (base instanceof StatisticsManagerSettingsImpl) {
            StatisticsManagerSettingsImpl impl = (StatisticsManagerSettingsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>>(casted.augmentations());
        }
    }

    public Integer getMaxNodesForCollector() {
        return this._maxNodesForCollector;
    }

    public Integer getMinRequestNetMonitorInterval() {
        return this._minRequestNetMonitorInterval;
    }

    public <E extends Augmentation<StatisticsManagerSettings>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StatisticsManagerSettingsBuilder setMaxNodesForCollector(Integer value) {
        this._maxNodesForCollector = value;
        return this;
    }

    public StatisticsManagerSettingsBuilder setMinRequestNetMonitorInterval(Integer value) {
        this._minRequestNetMonitorInterval = value;
        return this;
    }

    public StatisticsManagerSettingsBuilder addAugmentation(Class<? extends Augmentation<StatisticsManagerSettings>> augmentationType, Augmentation<StatisticsManagerSettings> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StatisticsManagerSettingsBuilder removeAugmentation(Class<? extends Augmentation<StatisticsManagerSettings>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StatisticsManagerSettings build() {
        return new StatisticsManagerSettingsImpl(this);
    }

    private static final class StatisticsManagerSettingsImpl
    implements StatisticsManagerSettings {
        private final Integer _maxNodesForCollector;
        private final Integer _minRequestNetMonitorInterval;
        private Map<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<StatisticsManagerSettings> getImplementedInterface() {
            return StatisticsManagerSettings.class;
        }

        private StatisticsManagerSettingsImpl(StatisticsManagerSettingsBuilder base) {
            this._maxNodesForCollector = base.getMaxNodesForCollector();
            this._minRequestNetMonitorInterval = base.getMinRequestNetMonitorInterval();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxNodesForCollector() {
            return this._maxNodesForCollector;
        }

        @Override
        public Integer getMinRequestNetMonitorInterval() {
            return this._minRequestNetMonitorInterval;
        }

        public <E extends Augmentation<StatisticsManagerSettings>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxNodesForCollector == null ? 0 : this._maxNodesForCollector.hashCode());
            result = 31 * result + (this._minRequestNetMonitorInterval == null ? 0 : this._minRequestNetMonitorInterval.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StatisticsManagerSettings.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StatisticsManagerSettings other = (StatisticsManagerSettings)obj;
            if (this._maxNodesForCollector == null ? other.getMaxNodesForCollector() != null : !this._maxNodesForCollector.equals(other.getMaxNodesForCollector())) {
                return false;
            }
            if (this._minRequestNetMonitorInterval == null ? other.getMinRequestNetMonitorInterval() != null : !this._minRequestNetMonitorInterval.equals(other.getMinRequestNetMonitorInterval())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StatisticsManagerSettingsImpl otherImpl = (StatisticsManagerSettingsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StatisticsManagerSettings>>, Augmentation<StatisticsManagerSettings>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("StatisticsManagerSettings [");
            boolean first = true;
            if (this._maxNodesForCollector != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxNodesForCollector=");
                builder.append(this._maxNodesForCollector);
            }
            if (this._minRequestNetMonitorInterval != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_minRequestNetMonitorInterval=");
                builder.append(this._minRequestNetMonitorInterval);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

