/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.FlowComparatorFactory;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.SimpleComparator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow;

public final class FlowComparator {
    private static final Collection<SimpleComparator<Flow>> FLOW_COMPARATORS = new ArrayList<SimpleComparator<Flow>>();

    private FlowComparator() {
        throw new UnsupportedOperationException("Utilities class should not be instantiated");
    }

    public static boolean flowEquals(Flow statsFlow, Flow storedFlow) {
        if (statsFlow == null || storedFlow == null) {
            return false;
        }
        for (SimpleComparator<Flow> flowComp : FLOW_COMPARATORS) {
            if (flowComp.areObjectsEqual(statsFlow, storedFlow)) continue;
            return false;
        }
        return true;
    }

    static {
        FLOW_COMPARATORS.add(FlowComparatorFactory.createPriority());
        FLOW_COMPARATORS.add(FlowComparatorFactory.createTableId());
        FLOW_COMPARATORS.add(FlowComparatorFactory.createContainerName());
        FLOW_COMPARATORS.add(FlowComparatorFactory.createCookie());
        FLOW_COMPARATORS.add(FlowComparatorFactory.createMatch());
    }
}

