/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.config.yang.statistics_manager;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.binding.DataBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.NotificationProviderServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.RpcProviderRegistryServiceInterface;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.openflowplugin.applications.config.yang.statistics_manager.StatisticsManagerModuleMXBean;
import org.opendaylight.openflowplugin.applications.config.yang.statistics_manager.StatisticsManagerSettings;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2014-09-25", name="statistics-manager", namespace="urn:opendaylight:params:xml:ns:yang:openflowplugin:app:statistics-manager")
public abstract class AbstractStatisticsManagerModule
extends AbstractModule<AbstractStatisticsManagerModule>
implements StatisticsManagerModuleMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStatisticsManagerModule.class);
    public static final JmxAttribute notificationServiceJmxAttribute = new JmxAttribute("NotificationService");
    private ObjectName notificationService;
    public static final JmxAttribute rpcRegistryJmxAttribute = new JmxAttribute("RpcRegistry");
    private ObjectName rpcRegistry;
    public static final JmxAttribute dataBrokerJmxAttribute = new JmxAttribute("DataBroker");
    private ObjectName dataBroker;
    public static final JmxAttribute statisticsManagerSettingsJmxAttribute = new JmxAttribute("StatisticsManagerSettings");
    private StatisticsManagerSettings statisticsManagerSettings;
    private NotificationProviderService notificationServiceDependency;
    private RpcProviderRegistry rpcRegistryDependency;
    private DataBroker dataBrokerDependency;

    public AbstractStatisticsManagerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractStatisticsManagerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractStatisticsManagerModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(NotificationProviderServiceServiceInterface.class, this.notificationService, notificationServiceJmxAttribute);
        this.dependencyResolver.validateDependency(RpcProviderRegistryServiceInterface.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        if (this.dataBroker != null) {
            this.dependencyResolver.validateDependency(DataBrokerServiceInterface.class, this.dataBroker, dataBrokerJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final NotificationProviderService getNotificationServiceDependency() {
        return this.notificationServiceDependency;
    }

    protected final RpcProviderRegistry getRpcRegistryDependency() {
        return this.rpcRegistryDependency;
    }

    protected final DataBroker getDataBrokerDependency() {
        return this.dataBrokerDependency;
    }

    protected final void resolveDependencies() {
        this.rpcRegistryDependency = (RpcProviderRegistry)this.dependencyResolver.resolveInstance(RpcProviderRegistry.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        if (this.dataBroker != null) {
            this.dataBrokerDependency = (DataBroker)this.dependencyResolver.resolveInstance(DataBroker.class, this.dataBroker, dataBrokerJmxAttribute);
        }
        this.notificationServiceDependency = (NotificationProviderService)this.dependencyResolver.resolveInstance(NotificationProviderService.class, this.notificationService, notificationServiceJmxAttribute);
        if (this.statisticsManagerSettings != null) {
            this.statisticsManagerSettings.injectDependencyResolver(this.dependencyResolver);
        }
    }

    public boolean canReuseInstance(AbstractStatisticsManagerModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractStatisticsManagerModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.notificationService, other.notificationService)) {
            return false;
        }
        if (this.notificationService != null && !this.dependencyResolver.canReuseDependency(this.notificationService, notificationServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.rpcRegistry, other.rpcRegistry)) {
            return false;
        }
        if (this.rpcRegistry != null && !this.dependencyResolver.canReuseDependency(this.rpcRegistry, rpcRegistryJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.dataBroker, other.dataBroker)) {
            return false;
        }
        if (this.dataBroker != null && !this.dependencyResolver.canReuseDependency(this.dataBroker, dataBrokerJmxAttribute)) {
            return false;
        }
        return Objects.deepEquals(this.statisticsManagerSettings, other.statisticsManagerSettings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStatisticsManagerModule that = (AbstractStatisticsManagerModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getNotificationService() {
        return this.notificationService;
    }

    @Override
    @RequireInterface(value=NotificationProviderServiceServiceInterface.class)
    public void setNotificationService(ObjectName notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public ObjectName getRpcRegistry() {
        return this.rpcRegistry;
    }

    @Override
    @RequireInterface(value=RpcProviderRegistryServiceInterface.class)
    public void setRpcRegistry(ObjectName rpcRegistry) {
        this.rpcRegistry = rpcRegistry;
    }

    @Override
    public ObjectName getDataBroker() {
        return this.dataBroker;
    }

    @Override
    @RequireInterface(value=DataBrokerServiceInterface.class)
    public void setDataBroker(ObjectName dataBroker) {
        this.dataBroker = dataBroker;
    }

    @Override
    public StatisticsManagerSettings getStatisticsManagerSettings() {
        return this.statisticsManagerSettings;
    }

    @Override
    public void setStatisticsManagerSettings(StatisticsManagerSettings statisticsManagerSettings) {
        this.statisticsManagerSettings = statisticsManagerSettings;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

