/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.infos;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.types.rev150122.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.info.PrefixList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.infos.RouterInfo;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.router.infos.RouterInfoKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RouterInfoBuilder
implements Builder<RouterInfo> {
    private Long _asn;
    private Uuid _id;
    private RouterInfoKey _key;
    private String _model;
    private Long _peerPathId;
    private List<PrefixList> _prefixList;
    private String _servicePeerIp;
    private String _vendor;
    Map<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>> augmentation = Collections.emptyMap();

    public RouterInfoBuilder() {
    }

    public RouterInfoBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo arg) {
        this._id = arg.getId();
        this._servicePeerIp = arg.getServicePeerIp();
        this._asn = arg.getAsn();
        this._vendor = arg.getVendor();
        this._model = arg.getModel();
        this._peerPathId = arg.getPeerPathId();
        this._prefixList = arg.getPrefixList();
    }

    public RouterInfoBuilder(RouterInfo base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new RouterInfoKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._asn = base.getAsn();
        this._model = base.getModel();
        this._peerPathId = base.getPeerPathId();
        this._prefixList = base.getPrefixList();
        this._servicePeerIp = base.getServicePeerIp();
        this._vendor = base.getVendor();
        if (base instanceof RouterInfoImpl) {
            RouterInfoImpl impl = (RouterInfoImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo) {
            this._id = ((org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo)arg).getId();
            this._servicePeerIp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo)arg).getServicePeerIp();
            this._asn = ((org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo)arg).getAsn();
            this._vendor = ((org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo)arg).getVendor();
            this._model = ((org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo)arg).getModel();
            this._peerPathId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo)arg).getPeerPathId();
            this._prefixList = ((org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo)arg).getPrefixList();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.info.rev170613.RouterInfo] \nbut was: " + arg);
        }
    }

    public Long getAsn() {
        return this._asn;
    }

    public Uuid getId() {
        return this._id;
    }

    public RouterInfoKey getKey() {
        return this._key;
    }

    public String getModel() {
        return this._model;
    }

    public Long getPeerPathId() {
        return this._peerPathId;
    }

    public List<PrefixList> getPrefixList() {
        return this._prefixList;
    }

    public String getServicePeerIp() {
        return this._servicePeerIp;
    }

    public String getVendor() {
        return this._vendor;
    }

    public <E extends Augmentation<RouterInfo>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkAsnRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public RouterInfoBuilder setAsn(Long value) {
        if (value != null) {
            RouterInfoBuilder.checkAsnRange(value);
        }
        this._asn = value;
        return this;
    }

    public RouterInfoBuilder setId(Uuid value) {
        this._id = value;
        return this;
    }

    public RouterInfoBuilder setKey(RouterInfoKey value) {
        this._key = value;
        return this;
    }

    public RouterInfoBuilder setModel(String value) {
        this._model = value;
        return this;
    }

    private static void checkPeerPathIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public RouterInfoBuilder setPeerPathId(Long value) {
        if (value != null) {
            RouterInfoBuilder.checkPeerPathIdRange(value);
        }
        this._peerPathId = value;
        return this;
    }

    public RouterInfoBuilder setPrefixList(List<PrefixList> value) {
        this._prefixList = value;
        return this;
    }

    public RouterInfoBuilder setServicePeerIp(String value) {
        this._servicePeerIp = value;
        return this;
    }

    public RouterInfoBuilder setVendor(String value) {
        this._vendor = value;
        return this;
    }

    public RouterInfoBuilder addAugmentation(Class<? extends Augmentation<RouterInfo>> augmentationType, Augmentation<RouterInfo> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RouterInfoBuilder removeAugmentation(Class<? extends Augmentation<RouterInfo>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RouterInfo build() {
        return new RouterInfoImpl(this);
    }

    private static final class RouterInfoImpl
    implements RouterInfo {
        private final Long _asn;
        private final Uuid _id;
        private final RouterInfoKey _key;
        private final String _model;
        private final Long _peerPathId;
        private final List<PrefixList> _prefixList;
        private final String _servicePeerIp;
        private final String _vendor;
        private Map<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RouterInfo> getImplementedInterface() {
            return RouterInfo.class;
        }

        private RouterInfoImpl(RouterInfoBuilder base) {
            if (base.getKey() == null) {
                this._key = new RouterInfoKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._asn = base.getAsn();
            this._model = base.getModel();
            this._peerPathId = base.getPeerPathId();
            this._prefixList = base.getPrefixList();
            this._servicePeerIp = base.getServicePeerIp();
            this._vendor = base.getVendor();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getAsn() {
            return this._asn;
        }

        @Override
        public Uuid getId() {
            return this._id;
        }

        @Override
        public RouterInfoKey getKey() {
            return this._key;
        }

        @Override
        public String getModel() {
            return this._model;
        }

        @Override
        public Long getPeerPathId() {
            return this._peerPathId;
        }

        @Override
        public List<PrefixList> getPrefixList() {
            return this._prefixList;
        }

        @Override
        public String getServicePeerIp() {
            return this._servicePeerIp;
        }

        @Override
        public String getVendor() {
            return this._vendor;
        }

        public <E extends Augmentation<RouterInfo>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._asn);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._model);
            result = 31 * result + Objects.hashCode(this._peerPathId);
            result = 31 * result + Objects.hashCode(this._prefixList);
            result = 31 * result + Objects.hashCode(this._servicePeerIp);
            result = 31 * result + Objects.hashCode(this._vendor);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RouterInfo.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RouterInfo other = (RouterInfo)obj;
            if (!Objects.equals(this._asn, other.getAsn())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._model, other.getModel())) {
                return false;
            }
            if (!Objects.equals(this._peerPathId, other.getPeerPathId())) {
                return false;
            }
            if (!Objects.equals(this._prefixList, other.getPrefixList())) {
                return false;
            }
            if (!Objects.equals(this._servicePeerIp, other.getServicePeerIp())) {
                return false;
            }
            if (!Objects.equals(this._vendor, other.getVendor())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RouterInfoImpl otherImpl = (RouterInfoImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RouterInfo>>, Augmentation<RouterInfo>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RouterInfo [";
            StringBuilder builder = new StringBuilder(name);
            if (this._asn != null) {
                builder.append("_asn=");
                builder.append(this._asn);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._model != null) {
                builder.append("_model=");
                builder.append(this._model);
                builder.append(", ");
            }
            if (this._peerPathId != null) {
                builder.append("_peerPathId=");
                builder.append(this._peerPathId);
                builder.append(", ");
            }
            if (this._prefixList != null) {
                builder.append("_prefixList=");
                builder.append(this._prefixList);
                builder.append(", ");
            }
            if (this._servicePeerIp != null) {
                builder.append("_servicePeerIp=");
                builder.append(this._servicePeerIp);
                builder.append(", ");
            }
            if (this._vendor != null) {
                builder.append("_vendor=");
                builder.append(this._vendor);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

