/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.netvirt.utils.mdsal.openflow.FlowUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeBuilder;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowCache {
    private static final Logger LOG = LoggerFactory.getLogger(FlowCache.class);
    private Map<String, Map<Integer, InstanceIdentifier<Flow>>> flowCache = new HashMap<String, Map<Integer, InstanceIdentifier<Flow>>>();

    public void addFlow(FlowBuilder flowBuilder, NodeBuilder nodeBuilder, String rspName, int flowId) {
        Map<Integer, InstanceIdentifier<Flow>> flowMap = this.flowCache.get(rspName);
        if (flowMap == null) {
            LOG.info("addFlow: adding new flowMap for {}({})", (Object)rspName, (Object)flowId);
            flowMap = new HashMap<Integer, InstanceIdentifier<Flow>>();
        }
        InstanceIdentifier path = FlowUtils.createFlowPath((FlowBuilder)flowBuilder, (NodeBuilder)nodeBuilder);
        flowMap.put(flowId, (InstanceIdentifier<Flow>)path);
        this.flowCache.put(rspName, flowMap);
        LOG.info("addFlow: added {}({}) {} to cache size {} - {}", new Object[]{rspName, flowId, path, this.flowCache.size(), this.flowCache});
    }

    public void removeFlow(String rspName, int flowId) {
        Map<Integer, InstanceIdentifier<Flow>> flowMap = this.flowCache.get(rspName);
        if (flowMap != null) {
            flowMap.remove(flowId);
            if (flowMap.isEmpty()) {
                this.flowCache.remove(rspName);
                LOG.info("removeFlow: removed flowMap {}({}) from cache size {}", new Object[]{rspName, flowId, this.flowCache.size()});
            } else {
                this.flowCache.put(rspName, flowMap);
            }
        }
        LOG.info("removeFlow: removed {}({}) from cache size {}", new Object[]{rspName, flowId, this.flowCache.size()});
    }

    public Map<Integer, InstanceIdentifier<Flow>> getFlows(String rspName) {
        return this.flowCache.get(rspName);
    }
}

