/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services;

import org.opendaylight.netvirt.utils.mdsal.openflow.MatchUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Matches;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceEth;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceIp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.ace.ip.version.AceIpv4;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.ace.ip.version.AceIpv6;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.EtherType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclMatches {
    private static final Logger LOG = LoggerFactory.getLogger(AclMatches.class);
    MatchBuilder matchBuilder = new MatchBuilder();
    Matches matches;

    public AclMatches(Matches matches) {
        this.matches = matches;
    }

    protected MatchBuilder buildMatch() {
        if (this.matches.getAceType() instanceof AceEth) {
            this.addEthMatch();
        } else if (this.matches.getAceType() instanceof AceIp) {
            this.addIpMatch();
        }
        LOG.info("buildMatch: {}", (Object)this.matchBuilder.build());
        return this.matchBuilder;
    }

    private void addEthMatch() {
        AceEth aceEth = (AceEth)this.matches.getAceType();
        MatchUtils.createEthSrcDstMatch((MatchBuilder)this.matchBuilder, (MacAddress)aceEth.getSourceMacAddress(), (MacAddress)aceEth.getDestinationMacAddress());
    }

    private void addIpMatch() {
        AceIp aceIp = (AceIp)this.matches.getAceType();
        if (aceIp.getDscp() != null) {
            MatchUtils.addDscp((MatchBuilder)this.matchBuilder, (short)aceIp.getDscp().getValue());
        }
        if (aceIp.getProtocol() != null) {
            this.addIpProtocolMatch(aceIp);
        }
        if (aceIp.getAceIpVersion() instanceof AceIpv4) {
            this.addIpV4Match(aceIp);
        }
        if (aceIp.getAceIpVersion() instanceof AceIpv6) {
            this.addIpV6Match(aceIp);
        }
    }

    private void addIpProtocolMatch(AceIp aceIp) {
        int srcPort = 0;
        int dstPort = 0;
        if (aceIp.getSourcePortRange() != null && aceIp.getSourcePortRange().getLowerPort() != null) {
            srcPort = aceIp.getSourcePortRange().getLowerPort().getValue();
        }
        if (aceIp.getDestinationPortRange() != null && aceIp.getDestinationPortRange().getLowerPort() != null) {
            dstPort = aceIp.getDestinationPortRange().getLowerPort().getValue();
        }
        MatchUtils.createIpProtocolMatch((MatchBuilder)this.matchBuilder, (short)aceIp.getProtocol());
        MatchUtils.addLayer4Match((MatchBuilder)this.matchBuilder, (int)aceIp.getProtocol().intValue(), (int)srcPort, (int)dstPort);
    }

    private void addIpV4Match(AceIp aceIp) {
        AceIpv4 aceIpv4 = (AceIpv4)aceIp.getAceIpVersion();
        MatchUtils.createEtherTypeMatch((MatchBuilder)this.matchBuilder, (EtherType)new EtherType(Long.valueOf(2048L)));
        this.matchBuilder = MatchUtils.addRemoteIpPrefix((MatchBuilder)this.matchBuilder, (Ipv4Prefix)aceIpv4.getSourceIpv4Network(), (Ipv4Prefix)aceIpv4.getDestinationIpv4Network());
    }

    private void addIpV6Match(AceIp aceIp) {
        AceIpv6 aceIpv6 = (AceIpv6)aceIp.getAceIpVersion();
        MatchUtils.createEtherTypeMatch((MatchBuilder)this.matchBuilder, (EtherType)new EtherType(Long.valueOf(34525L)));
        this.matchBuilder = MatchUtils.addRemoteIpv6Prefix((MatchBuilder)this.matchBuilder, (Ipv6Prefix)aceIpv6.getSourceIpv6Network(), (Ipv6Prefix)aceIpv6.getDestinationIpv6Network());
    }
}

