/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc.standalone.openflow13;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.StringTokenizer;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.netvirt.openstack.netvirt.api.NodeCacheManager;
import org.opendaylight.netvirt.openstack.netvirt.api.Southbound;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcOF13Provider;
import org.opendaylight.netvirt.openstack.netvirt.sfc.ISfcClassifierService;
import org.opendaylight.netvirt.openstack.netvirt.sfc.NshUtils;
import org.opendaylight.netvirt.openstack.netvirt.sfc.standalone.openflow13.SfcClassifier;
import org.opendaylight.netvirt.utils.mdsal.utils.MdsalUtils;
import org.opendaylight.netvirt.utils.servicehelper.ServiceHelper;
import org.opendaylight.sfc.provider.api.SfcProviderRenderedPathAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServicePathAPI;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.CreateRenderedPathInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.CreateRenderedPathInputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.RenderedServicePaths;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.path.first.hop.info.RenderedServicePathFirstHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePathKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.rendered.service.path.RenderedServicePathHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.ServiceFunctionPaths;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.ServiceFunctionPath;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.Acl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.Ace;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Matches;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceIp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.ace.ip.version.AceIpv4;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.acl.rev150105.RedirectToSfc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.Classifiers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.Classifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.classifier.Bridges;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.classifier.bridges.Bridge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.classifier.sffs.Sff;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetvirtSfcStandaloneOF13Provider
implements INetvirtSfcOF13Provider {
    private static final Logger LOG = LoggerFactory.getLogger(NetvirtSfcStandaloneOF13Provider.class);
    private static final short TABLE_0_CLASSIFIER = 0;
    private static final short TABLE_3_INGR_ACL = 50;
    private volatile NodeCacheManager nodeCacheManager;
    private volatile Southbound southbound;
    private MdsalUtils mdsalUtils;
    private SfcClassifier sfcClassifier;
    private static final String TUNNEL_DST = "192.168.50.75";
    private static final String TUNNEL_VNID = "10";
    private static final String CLIENT_PORT_NAME = "vethl-h35_2";
    private static final String SERVER_PORT_NAME = "vethl-h35_4";
    private static final String CLIENT_GPE_PORT_NAME = "sw1-vxlangpe-0";
    private static final String SERVER_GPE_PORT_NAME = "sw6-vxlangpe-0";
    private static final String INTERFACE_TYPE_VXLAN_GPE = "vxlangpe";

    public NetvirtSfcStandaloneOF13Provider(DataBroker dataBroker) {
        Preconditions.checkNotNull((Object)dataBroker, (Object)"Input dataBroker cannot be NULL!");
        this.mdsalUtils = new MdsalUtils(dataBroker);
        this.sfcClassifier = new SfcClassifier(dataBroker, this.southbound, this.mdsalUtils);
    }

    @Override
    public void removeClassifierRules(Sff sff, Acl acl) {
    }

    @Override
    public void addClassifierRules(Acl acl) {
        String aclName = acl.getAclName();
        Classifiers classifiers = (Classifiers)this.mdsalUtils.read(LogicalDatastoreType.CONFIGURATION, this.getClassifierIid());
        if (classifiers == null) {
            LOG.debug("add: No Classifiers found");
            return;
        }
        LOG.debug("add: Classifiers: {}", (Object)classifiers);
        for (Classifier classifier : classifiers.getClassifier()) {
            if (!classifier.getAcl().equals(aclName) || classifier.getBridges() == null) continue;
            this.addClassifierRules(classifier.getBridges(), acl);
        }
    }

    @Override
    public void removeClassifierRules(Acl acl) {
        String aclName = acl.getAclName();
        Classifiers classifiers = (Classifiers)this.mdsalUtils.read(LogicalDatastoreType.CONFIGURATION, this.getClassifierIid());
        if (classifiers != null) {
            for (Classifier classifier : classifiers.getClassifier()) {
                if (!classifier.getAcl().equalsIgnoreCase(aclName) || classifier.getSffs() == null) continue;
                for (Sff sff : classifier.getSffs().getSff()) {
                    this.removeClassifierRules(sff, acl);
                }
            }
        }
    }

    @Override
    public void setSfcClassifierService(ISfcClassifierService sfcClassifierService) {
    }

    @Override
    public void addClassifierRules(Bridge bridge, Acl acl) {
    }

    @Override
    public void addClassifierRules(Bridges bridges, Acl acl) {
        Preconditions.checkNotNull((Object)bridges, (Object)"Input bridges cannot be NULL!");
        Preconditions.checkNotNull((Object)acl, (Object)"Input accesslist cannot be NULL!");
        for (Ace ace : acl.getAccessListEntries().getAce()) {
            this.processAclEntry(ace, bridges, true);
        }
    }

    private void processAclEntry(Ace entry, Bridges bridges, boolean write) {
        Matches matches = entry.getMatches();
        if (matches == null) {
            LOG.warn("processAclEntry: matches not found");
            return;
        }
        RenderedServicePath rsp = this.getRenderedServicePath(entry);
        if (rsp == null) {
            LOG.warn("Failed to get renderedServicePatch for entry: {}", (Object)entry);
            return;
        }
        LOG.info("processAclEntry: RSP: {}", (Object)rsp);
        List pathHopList = rsp.getRenderedServicePathHop();
        if (pathHopList.isEmpty()) {
            LOG.warn("Service Path = {} has empty hops!!", (Object)rsp.getName());
            return;
        }
        for (Bridge bridge : bridges.getBridge()) {
            NshUtils nshHeader;
            long localOfPort;
            long tunnelOfPort;
            Node bridgeNode;
            if (bridge.getDirection().getIntValue() == 0) {
                bridgeNode = this.getBridgeNode(bridge.getName());
                if (bridgeNode == null) {
                    LOG.debug("processAclEntry: bridge {} not yet configured. Skip processing !!", (Object)bridge.getName());
                    continue;
                }
                tunnelOfPort = this.southbound.getOFPort(bridgeNode, CLIENT_GPE_PORT_NAME);
                if (tunnelOfPort == 0L) {
                    LOG.error("programAclEntry: Could not identify tunnel port {} -> OF ({}) on {}", new Object[]{CLIENT_GPE_PORT_NAME, tunnelOfPort, bridgeNode});
                    return;
                }
                localOfPort = this.southbound.getOFPort(bridgeNode, CLIENT_PORT_NAME);
                if (localOfPort == 0L) {
                    LOG.error("programAclEntry: Could not identify local port {} -> OF ({}) on {}", new Object[]{CLIENT_PORT_NAME, localOfPort, bridgeNode});
                    return;
                }
                RenderedServicePathFirstHop firstRspHop = SfcProviderRenderedPathAPI.readRenderedServicePathFirstHop((RspName)new RspName(rsp.getName()));
                LOG.debug("First Hop IPAddress = {}, Port = {}", (Object)firstRspHop.getIp().getIpv4Address().getValue(), (Object)firstRspHop.getPort().getValue());
                nshHeader = new NshUtils();
                nshHeader.setNshMetaC1(NshUtils.convertIpAddressToLong(new Ipv4Address(TUNNEL_DST)));
                nshHeader.setNshMetaC2(Long.parseLong(TUNNEL_VNID));
                nshHeader.setNshNsp(rsp.getPathId());
                RenderedServicePathHop firstHop = (RenderedServicePathHop)pathHopList.get(0);
                nshHeader.setNshNsi(firstHop.getServiceIndex());
                nshHeader.setNshTunIpDst(firstRspHop.getIp().getIpv4Address());
                nshHeader.setNshTunUdpPort(firstRspHop.getPort());
                LOG.debug("The Nsh Header = {}", (Object)nshHeader);
                this.handleLocalInPort(this.southbound.getDataPathId(bridgeNode), rsp.getPathId().toString(), localOfPort, (short)0, (short)50, matches, true);
                this.handleSfcClassiferFlows(this.southbound.getDataPathId(bridgeNode), (short)50, entry.getRuleName(), matches, nshHeader, tunnelOfPort, true);
                continue;
            }
            bridgeNode = this.getBridgeNode(bridge.getName());
            if (bridgeNode == null) {
                LOG.debug("processAclEntry: bridge {} not yet configured. Skip processing !!", (Object)bridge.getName());
                continue;
            }
            tunnelOfPort = this.southbound.getOFPort(bridgeNode, SERVER_GPE_PORT_NAME);
            if (tunnelOfPort == 0L) {
                LOG.error("programAclEntry: Could not identify tunnel port {} -> OF ({}) on {}", new Object[]{SERVER_GPE_PORT_NAME, tunnelOfPort, bridgeNode});
                return;
            }
            localOfPort = this.southbound.getOFPort(bridgeNode, SERVER_PORT_NAME);
            if (localOfPort == 0L) {
                LOG.error("programAclEntry: Could not identify local port {} -> OF ({}) on {}", new Object[]{SERVER_PORT_NAME, localOfPort, bridgeNode});
                return;
            }
            RenderedServicePathHop lastRspHop = (RenderedServicePathHop)Iterables.getLast((Iterable)rsp.getRenderedServicePathHop());
            LOG.debug("programAclEntry: Last Hop #: {}, nsi: {}", (Object)lastRspHop.getHopNumber().intValue(), (Object)(lastRspHop.getServiceIndex().intValue() - 1));
            nshHeader = new NshUtils();
            nshHeader.setNshNsp(rsp.getPathId());
            nshHeader.setNshNsi((short)(lastRspHop.getServiceIndex().intValue() - 1));
            nshHeader.setNshMetaC2(Long.parseLong(TUNNEL_VNID));
            LOG.debug("programAclEntry: The Nsh Header = {}", (Object)nshHeader);
            this.handleEgressSfcClassiferFlows(this.southbound.getDataPathId(bridgeNode), (short)0, entry.getRuleName(), matches, nshHeader, tunnelOfPort, localOfPort, true);
        }
    }

    private RenderedServicePath getRenderedServicePath(Ace entry) {
        RenderedServicePath rsp = null;
        RedirectToSfc sfcRedirect = (RedirectToSfc)entry.getActions().getAugmentation(RedirectToSfc.class);
        LOG.debug("Processing ACL entry = {} sfcRedirect = {}", (Object)entry.getRuleName(), (Object)sfcRedirect);
        if (sfcRedirect == null) {
            LOG.warn("processAClEntry: sfcRedirect is null");
            return null;
        }
        if (sfcRedirect.getRspName() != null) {
            rsp = this.getRenderedServicePathFromRsp(sfcRedirect.getRspName());
        } else if (sfcRedirect.getSfpName() != null) {
            LOG.warn("getRenderedServicePath: sfp not handled yet");
        } else {
            rsp = this.getRenderedServicePathFromSfc(entry);
        }
        LOG.info("getRenderedServicePath: rsp: {}", (Object)rsp);
        return rsp;
    }

    private RenderedServicePath getRenderedServicePathFromRsp(String rspName) {
        return null;
    }

    private RenderedServicePath getRenderedServicePathFromSfc(Ace entry) {
        RedirectToSfc sfcRedirect = (RedirectToSfc)entry.getActions().getAugmentation(RedirectToSfc.class);
        LOG.debug("Processing ACL entry = {} sfcRedirect = {}", (Object)entry.getRuleName(), (Object)sfcRedirect);
        if (sfcRedirect == null) {
            LOG.warn("processAClEntry: sfcRedirect is null");
            return null;
        }
        String sfcName = sfcRedirect.getSfcName();
        ServiceFunctionPath sfp = this.getSfp(sfcName);
        if (sfp == null || sfp.getName() == null) {
            LOG.warn("There is no configured SFP with sfcName = {}; so skip installing the ACL entry!!", (Object)sfcName);
            return null;
        }
        LOG.debug("Processing Redirect to SFC = {}, SFP = {}", (Object)sfcName, (Object)sfp);
        String sfpName = sfp.getName().getValue();
        RenderedServicePath rsp = this.getRspforSfp(sfpName);
        String rspName = sfp.getName().getValue() + "_rsp";
        if (rsp == null) {
            LOG.info("No configured RSP corresponding to SFP = {}, Creating new RSP = {}", (Object)sfpName, (Object)rspName);
            CreateRenderedPathInput rspInput = new CreateRenderedPathInputBuilder().setParentServiceFunctionPath(sfpName).setName(rspName).setSymmetric(sfp.isSymmetric()).build();
            rsp = SfcProviderRenderedPathAPI.createRenderedServicePathAndState((ServiceFunctionPath)sfp, (CreateRenderedPathInput)rspInput);
            if (rsp == null) {
                LOG.warn("failed to add RSP");
                return null;
            }
            if (sfp.isSymmetric().booleanValue()) {
                LOG.info("SFP = {} is symmetric, installing RSP in the reverse direction!!", (Object)sfpName);
                String rspNameRev = rspName + "-Reverse";
                RenderedServicePath rspReverse = (RenderedServicePath)this.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, this.getRspId(rspNameRev));
                if (rspReverse == null && (rspReverse = SfcProviderRenderedPathAPI.createSymmetricRenderedServicePathAndState((RenderedServicePath)rsp)) == null) {
                    LOG.warn("failed to add reverse RSP");
                    return null;
                }
            }
        }
        return rsp;
    }

    private void handleLocalEgressPort(long dataPathId, String s, long localOfPort, short writeTable, short gotoTable, boolean write) {
    }

    private void handleEgressSfcClassiferFlows(long dataPathId, short writeTable, String ruleName, Matches matches, NshUtils nshHeader, long tunnelOfPort, long outOfPort, boolean write) {
        this.sfcClassifier.programEgressSfcClassiferFlows(dataPathId, writeTable, ruleName, matches, nshHeader, tunnelOfPort, outOfPort, write);
    }

    private void handleSfcClassiferFlows(long dataPathId, short writeTable, String ruleName, Matches matches, NshUtils nshHeader, long tunnelOfPort, boolean write) {
        this.sfcClassifier.programSfcClassiferFlows(dataPathId, writeTable, ruleName, matches, nshHeader, tunnelOfPort, write);
    }

    private InstanceIdentifier<RenderedServicePaths> getRspsId() {
        return InstanceIdentifier.builder(RenderedServicePaths.class).build();
    }

    private InstanceIdentifier<RenderedServicePath> getRspId(String rspName) {
        return InstanceIdentifier.builder(RenderedServicePaths.class).child(RenderedServicePath.class, (Identifier)new RenderedServicePathKey(new RspName(rspName))).build();
    }

    public Node getBridgeNode(String bridgeName) {
        Node nodeFound = null;
        List nodes = this.nodeCacheManager.getBridgeNodes();
        if (nodes != null && !nodes.isEmpty()) {
            for (Node node : nodes) {
                if (this.southbound.getBridge(node, bridgeName) == null) continue;
                nodeFound = node;
                break;
            }
        }
        return nodeFound;
    }

    public RenderedServicePath getRspforSfp(String sfpName) {
        RenderedServicePath rspFound = null;
        RenderedServicePaths rsps = (RenderedServicePaths)this.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, this.getRspsId());
        if (rsps != null) {
            for (RenderedServicePath rsp : rsps.getRenderedServicePath()) {
                if (rsp.getParentServiceFunctionPath() == null || !rsp.getParentServiceFunctionPath().getValue().equals(sfpName)) continue;
                rspFound = rsp;
            }
        }
        return rspFound;
    }

    public ServiceFunctionPath getSfp(String redirectSfc) {
        ServiceFunctionPath sfpFound = null;
        ServiceFunctionPaths sfps = SfcProviderServicePathAPI.readAllServiceFunctionPaths();
        if (sfps != null) {
            for (ServiceFunctionPath sfp : sfps.getServiceFunctionPath()) {
                if (!sfp.getServiceChainName().getValue().equalsIgnoreCase(redirectSfc)) continue;
                sfpFound = sfp;
            }
        }
        return sfpFound;
    }

    public String getDestIp(Matches match) {
        AceIpv4 aceIpv4;
        AceIp aceIp;
        if (match.getAceType() instanceof AceIp && (aceIp = (AceIp)match.getAceType()).getAceIpVersion() instanceof AceIpv4 && (aceIpv4 = (AceIpv4)aceIp.getAceIpVersion()).getDestinationIpv4Network() != null) {
            String ipAddrPrefix = aceIpv4.getDestinationIpv4Network().getValue();
            return new StringTokenizer(ipAddrPrefix, "/").nextToken();
        }
        return null;
    }

    public String getSourceIp(Matches match) {
        AceIpv4 aceIpv4;
        AceIp aceIp;
        if (match.getAceType() instanceof AceIp && (aceIp = (AceIp)match.getAceType()).getAceIpVersion() instanceof AceIpv4 && (aceIpv4 = (AceIpv4)aceIp.getAceIpVersion()).getSourceIpv4Network() != null) {
            return aceIpv4.getSourceIpv4Network().getValue();
        }
        return null;
    }

    private InstanceIdentifier<Classifiers> getClassifierIid() {
        return InstanceIdentifier.create(Classifiers.class);
    }

    public void handleLocalInPort(long dpidLong, String segmentationId, Long inPort, short writeTable, short goToTableId, Matches matches, boolean write) {
        this.sfcClassifier.programLocalInPort(dpidLong, segmentationId, inPort, writeTable, goToTableId, matches, write);
    }

    @Override
    public void setDependencies(ServiceReference serviceReference) {
        this.nodeCacheManager = (NodeCacheManager)ServiceHelper.getGlobalInstance(NodeCacheManager.class, (Object)this);
        this.southbound = (Southbound)ServiceHelper.getGlobalInstance(Southbound.class, (Object)this);
    }

    @Override
    public void removeRsp(RenderedServicePath change) {
        LOG.warn("removeRsp is not implemented yet");
    }

    @Override
    public void addRsp(RenderedServicePath change) {
        LOG.warn("addRsp is not implemented yet");
    }

    @Override
    public void updateRsp(RenderedServicePath change) {
        LOG.warn("updateRsp is not implemented yet");
    }
}

