/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;

public class NshUtils {
    private Ipv4Address nshTunIpDst;
    private PortNumber nshTunUdpPort;
    private long nshNsp;
    private short nshNsi;
    private long nshMetaC1;
    private long nshMetaC2;

    public NshUtils() {
    }

    public NshUtils(Ipv4Address nshTunIpDst, PortNumber nshTunUdpPort, long nshNsp, short nshNsi, long nshMetaC1, long nshMetaC2) {
        this.nshTunIpDst = nshTunIpDst;
        this.nshTunUdpPort = nshTunUdpPort;
        this.nshNsp = nshNsp;
        this.nshNsi = nshNsi;
        this.nshMetaC1 = nshMetaC1;
        this.nshMetaC2 = nshMetaC2;
    }

    public Ipv4Address getNshTunIpDst() {
        return this.nshTunIpDst;
    }

    public void setNshTunIpDst(Ipv4Address nshTunIpDst) {
        this.nshTunIpDst = nshTunIpDst;
    }

    public PortNumber getNshTunUdpPort() {
        return this.nshTunUdpPort;
    }

    public void setNshTunUdpPort(PortNumber nshTunUdpPort) {
        this.nshTunUdpPort = nshTunUdpPort;
    }

    public long getNshNsp() {
        return this.nshNsp;
    }

    public void setNshNsp(long nshNsp) {
        this.nshNsp = nshNsp;
    }

    public short getNshNsi() {
        return this.nshNsi;
    }

    public void setNshNsi(short nshNsi) {
        this.nshNsi = nshNsi;
    }

    public long getNshMetaC1() {
        return this.nshMetaC1;
    }

    public void setNshMetaC1(long nshMetaC1) {
        this.nshMetaC1 = nshMetaC1;
    }

    public long getNshMetaC2() {
        return this.nshMetaC2;
    }

    public void setNshMetaC2(long nshMetaC2) {
        this.nshMetaC2 = nshMetaC2;
    }

    public static Long convertIpAddressToLong(Ipv4Address ipv4Address) {
        return (long)InetAddresses.coerceToInteger((InetAddress)InetAddresses.forString((String)ipv4Address.getValue())) & 0xFFFFFFFFL;
    }

    public String toString() {
        return "NshUtils [nshTunIpDst=" + this.nshTunIpDst + ", nshTunUdpPort=" + this.nshTunUdpPort + ", nshNsp=" + this.nshNsp + ", nshNsi=" + this.nshNsi + ", nshMetaC1=" + this.nshMetaC1 + ", nshMetaC2=" + this.nshMetaC2 + "]";
    }
}

