/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcDataProcessor;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcOF13Provider;
import org.opendaylight.netvirt.utils.mdsal.utils.MdsalUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.AccessLists;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.AclBase;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.Acl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.AclKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.Classifier;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetvirtSfcClassifierDataProcessor
implements INetvirtSfcDataProcessor<Classifier> {
    private static final Logger LOG = LoggerFactory.getLogger(NetvirtSfcClassifierDataProcessor.class);
    private final MdsalUtils mdsalUtils;
    private final INetvirtSfcOF13Provider provider;

    public NetvirtSfcClassifierDataProcessor(INetvirtSfcOF13Provider provider, DataBroker db) {
        this.provider = (INetvirtSfcOF13Provider)Preconditions.checkNotNull((Object)provider, (Object)"Provider can not be null!");
        Preconditions.checkNotNull((Object)db, (Object)"DataBroker can not be null!");
        this.mdsalUtils = new MdsalUtils(db);
    }

    @Override
    public void remove(InstanceIdentifier<Classifier> identifier, Classifier change) {
        Preconditions.checkNotNull((Object)change, (Object)"Added object can not be null!");
        String aclName = change.getAcl();
        Acl acl = (Acl)this.mdsalUtils.read(LogicalDatastoreType.CONFIGURATION, this.getIetfAclIid(aclName));
        if (acl == null) {
            LOG.debug("IETF ACL with name ={} is not yet configured. skip this operation", (Object)aclName);
            return;
        }
        this.provider.removeClassifierRules(acl);
    }

    @Override
    public void update(InstanceIdentifier<Classifier> identifier, Classifier original, Classifier change) {
    }

    @Override
    public void add(InstanceIdentifier<Classifier> identifier, Classifier change) {
        Preconditions.checkNotNull((Object)change, (Object)"Added object can not be null!");
        String aclName = change.getAcl();
        Acl acl = (Acl)this.mdsalUtils.read(LogicalDatastoreType.CONFIGURATION, this.getIetfAclIid(aclName));
        if (acl == null) {
            LOG.debug("IETF ACL with name ={} is not yet configured. skip this operation", (Object)aclName);
            return;
        }
        this.provider.addClassifierRules(acl);
    }

    private InstanceIdentifier<Acl> getIetfAclIid(String aclName) {
        return InstanceIdentifier.create(AccessLists.class).child(Acl.class, (Identifier)new AclKey(aclName, AclBase.class));
    }
}

