/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.messages;

import com.google.common.collect.ImmutableMap;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class NotificationMessage
extends NetconfMessage {
    public static final @NonNull String ELEMENT_NAME = "notification";
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMessage.class);
    public static final Instant UNKNOWN_EVENT_TIME = Instant.EPOCH;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;
    public static final Function<Instant, String> RFC3339_DATE_FORMATTER = date -> DATE_TIME_FORMATTER.format(date.atOffset(ZoneOffset.UTC));
    public static final Function<String, Instant> RFC3339_DATE_PARSER = time -> {
        try {
            return ZonedDateTime.parse(time, DATE_TIME_FORMATTER).toInstant();
        }
        catch (DateTimeParseException exception) {
            Instant res = NotificationMessage.handlePotentialLeapSecond(time);
            if (res != null) {
                return res;
            }
            throw exception;
        }
    };
    private final @NonNull Instant eventTime;

    private static Instant handlePotentialLeapSecond(String time) {
        boolean offset = false;
        TemporalAccessor parsed = DATE_TIME_FORMATTER.parseUnresolved(time, new ParsePosition(0));
        if (parsed == null) {
            return null;
        }
        int secondOfMinute = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.SECOND_OF_MINUTE);
        int hourOfDay = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.HOUR_OF_DAY);
        int minuteOfHour = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.MINUTE_OF_HOUR);
        if (secondOfMinute != 60 || minuteOfHour != 59 || hourOfDay != 23) {
            return null;
        }
        LOG.trace("Received time contains leap second, adjusting by replacing the second-of-minute of 60 with 59 {}", (Object)time);
        secondOfMinute = 59;
        int year = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.YEAR);
        int monthOfYear = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.MONTH_OF_YEAR);
        int dayOfMonth = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.DAY_OF_MONTH);
        int nanoOfSecond = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.NANO_OF_SECOND);
        int offsetSeconds = NotificationMessage.getFieldFromTemporalAccessor(parsed, ChronoField.OFFSET_SECONDS);
        LocalDateTime currentTime = LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        OffsetDateTime dateTimeWithZoneOffset = currentTime.atOffset(ZoneOffset.ofTotalSeconds(offsetSeconds));
        return RFC3339_DATE_PARSER.apply(dateTimeWithZoneOffset.toString());
    }

    private static int getFieldFromTemporalAccessor(TemporalAccessor accessor, ChronoField field) {
        return accessor.isSupported(field) ? (int)accessor.getLong(field) : 0;
    }

    private NotificationMessage(Document notificationContent, Instant eventTime) {
        super(notificationContent);
        this.eventTime = Objects.requireNonNull(eventTime);
    }

    static @NonNull NotificationMessage ofChecked(Document document) throws DocumentedException {
        NodeList eventTime = document.getDocumentElement().getElementsByTagNameNS("urn:ietf:params:xml:ns:netconf:notification:1.0", "eventTime");
        if (eventTime.getLength() < 1) {
            throw new DocumentedException("Missing event-time", ErrorType.PROTOCOL, ErrorTag.MISSING_ELEMENT, ErrorSeverity.ERROR, (Map<String, String>)ImmutableMap.of());
        }
        return new NotificationMessage(document, RFC3339_DATE_PARSER.apply(eventTime.item(0).getTextContent()));
    }

    public static @NonNull NotificationMessage ofNotificationContent(Document notificationContent, Instant eventTime) {
        return new NotificationMessage(NotificationMessage.wrapNotification(notificationContent, eventTime), eventTime);
    }

    public static @NonNull NotificationMessage ofNotificationContent(Document notificationContent) {
        return NotificationMessage.ofNotificationContent(notificationContent, Instant.now());
    }

    public @NonNull Instant getEventTime() {
        return this.eventTime;
    }

    private static Document wrapNotification(Document notificationContent, Instant eventTime) {
        Objects.requireNonNull(notificationContent);
        Objects.requireNonNull(eventTime);
        Element baseNotification = notificationContent.getDocumentElement();
        Element entireNotification = notificationContent.createElementNS("urn:ietf:params:xml:ns:netconf:notification:1.0", ELEMENT_NAME);
        entireNotification.appendChild(baseNotification);
        Element eventTimeElement = notificationContent.createElementNS("urn:ietf:params:xml:ns:netconf:notification:1.0", "eventTime");
        eventTimeElement.setTextContent(RFC3339_DATE_FORMATTER.apply(eventTime));
        entireNotification.appendChild(eventTimeElement);
        notificationContent.appendChild(entireNotification);
        return notificationContent;
    }
}

