/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.trace.impl;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.trace.impl.AbstractTracingWriteTransaction;
import org.opendaylight.mdsal.trace.impl.CloseTracked;
import org.opendaylight.mdsal.trace.impl.CloseTrackedRegistry;
import org.opendaylight.mdsal.trace.impl.CloseTrackedTrait;
import org.opendaylight.mdsal.trace.impl.TracingBroker;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

class TracingReadWriteTransaction
extends AbstractTracingWriteTransaction
implements DOMDataTreeReadWriteTransaction,
CloseTracked<TracingReadWriteTransaction> {
    private final CloseTrackedTrait<TracingReadWriteTransaction> closeTracker;
    private final DOMDataTreeReadWriteTransaction delegate;

    TracingReadWriteTransaction(DOMDataTreeReadWriteTransaction delegate, TracingBroker tracingBroker, CloseTrackedRegistry<TracingReadWriteTransaction> readWriteTransactionsRegistry) {
        super((DOMDataTreeWriteTransaction)delegate, tracingBroker);
        this.closeTracker = new CloseTrackedTrait<TracingReadWriteTransaction>(readWriteTransactionsRegistry, this);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public FluentFuture<Optional<NormalizedNode>> read(LogicalDatastoreType store, YangInstanceIdentifier yiid) {
        return this.delegate.read(store, yiid);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier yiid) {
        return this.delegate.exists(store, yiid);
    }

    @Override
    public FluentFuture<? extends CommitInfo> commit() {
        this.closeTracker.removeFromTrackedRegistry();
        return super.commit();
    }

    @Override
    public boolean cancel() {
        this.closeTracker.removeFromTrackedRegistry();
        return super.cancel();
    }

    @Override
    public @Nullable StackTraceElement[] getAllocationContextStackTrace() {
        return this.closeTracker.getAllocationContextStackTrace();
    }

    @Override
    public CloseTracked<TracingReadWriteTransaction> getRealCloseTracked() {
        return this;
    }
}

