/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.trace.impl;

import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.trace.impl.TracingBroker;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class AbstractTracingWriteTransaction
implements DOMDataTreeWriteTransaction {
    private final List<String> logs = new ArrayList<String>();
    private final DOMDataTreeWriteTransaction delegate;
    private final TracingBroker tracingBroker;

    AbstractTracingWriteTransaction(DOMDataTreeWriteTransaction delegate, TracingBroker tracingBroker) {
        this.delegate = Objects.requireNonNull(delegate);
        this.tracingBroker = Objects.requireNonNull(tracingBroker);
        this.recordOp(null, null, "instantiate", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordOp(LogicalDatastoreType store, YangInstanceIdentifier yiid, String method, NormalizedNode node) {
        Set set;
        Object value;
        if (yiid != null && !this.tracingBroker.isWriteWatched(yiid, store)) {
            return;
        }
        Object object = value = node != null ? node.body() : null;
        if (value instanceof Set && (set = (Set)value).isEmpty()) {
            this.tracingBroker.logEmptySet(yiid);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Method \"").append(method).append('\"');
            if (store != null) {
                sb.append(" to ").append(store);
            }
            if (yiid != null) {
                sb.append(" at ").append(this.tracingBroker.toPathString(yiid));
            }
            sb.append('.');
            if (yiid != null) {
                sb.append(" Data: ");
                if (node != null) {
                    sb.append(node.body());
                } else {
                    sb.append("null");
                }
            }
            sb.append(" Stack:").append(this.tracingBroker.getStackSummary());
            AbstractTracingWriteTransaction abstractTracingWriteTransaction = this;
            synchronized (abstractTracingWriteTransaction) {
                this.logs.add(sb.toString());
            }
        }
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier yiid, NormalizedNode node) {
        this.recordOp(store, yiid, "put", node);
        this.delegate.put(store, yiid, node);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier yiid, NormalizedNode node) {
        this.recordOp(store, yiid, "merge", node);
        this.delegate.merge(store, yiid, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        AbstractTracingWriteTransaction abstractTracingWriteTransaction = this;
        synchronized (abstractTracingWriteTransaction) {
            this.logs.clear();
        }
        return this.delegate.cancel();
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier yiid) {
        this.recordOp(store, yiid, "delete", null);
        this.delegate.delete(store, yiid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluentFuture<? extends CommitInfo> commit() {
        this.recordOp(null, null, "commit", null);
        AbstractTracingWriteTransaction abstractTracingWriteTransaction = this;
        synchronized (abstractTracingWriteTransaction) {
            TracingBroker.logOperations(this.getIdentifier(), this.logs);
            this.logs.clear();
        }
        return this.delegate.commit();
    }

    public Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public final FluentFuture<?> completionFuture() {
        return this.delegate.completionFuture();
    }

    public final boolean equals(Object object) {
        return object == this || this.delegate.equals(object);
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + "; delegate=" + this.delegate;
    }
}

