/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.infrautils.diagstatus.InstantDeserializer;
import org.opendaylight.infrautils.diagstatus.InstantSerializer;
import org.opendaylight.infrautils.diagstatus.ServiceDescriptor;
import org.opendaylight.infrautils.diagstatus.ThrowableAdapterFactory;
import org.opendaylight.infrautils.ready.SystemState;

public final class ServiceStatusSummary {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().registerTypeAdapterFactory((TypeAdapterFactory)ThrowableAdapterFactory.INSTANCE).registerTypeAdapter(Instant.class, (Object)new InstantSerializer()).registerTypeAdapter(Instant.class, (Object)new InstantDeserializer()).create();
    private final Instant timeStamp = Instant.now();
    private final boolean isOperational;
    private final SystemState systemReadyState;
    private final String systemReadyStateErrorCause;
    private final Set<ServiceDescriptor> statusSummary;

    public static ServiceStatusSummary fromJSON(String json) {
        return (ServiceStatusSummary)GSON.fromJson(json, ServiceStatusSummary.class);
    }

    public ServiceStatusSummary(boolean isOperational, SystemState systemState, String systemReadyErrorCause, Set<ServiceDescriptor> statusSummary) {
        this.isOperational = isOperational;
        this.systemReadyState = systemState;
        this.statusSummary = statusSummary;
        this.systemReadyStateErrorCause = systemReadyErrorCause;
    }

    public String toJSON() {
        return GSON.toJson((Object)this);
    }

    public boolean isOperational() {
        return this.isOperational;
    }

    public SystemState getSystemReadyState() {
        return this.systemReadyState;
    }

    public String getSystemReadyStateErrorCause() {
        return this.systemReadyStateErrorCause;
    }

    public Collection<ServiceDescriptor> getStatusSummary() {
        return this.statusSummary;
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ServiceStatusSummary)) return false;
        ServiceStatusSummary that = (ServiceStatusSummary)obj;
        if (this.isOperational != that.isOperational) return false;
        if (!Objects.equals(this.systemReadyState, that.systemReadyState)) return false;
        if (!Objects.equals(this.systemReadyStateErrorCause, that.systemReadyStateErrorCause)) return false;
        if (!Objects.equals(this.statusSummary, that.statusSummary)) return false;
        if (!Objects.equals(this.timeStamp, that.timeStamp)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.isOperational(), this.getSystemReadyState(), this.getSystemReadyStateErrorCause(), this.getStatusSummary(), this.getTimeStamp());
    }

    public String toString() {
        return "ServiceStatusSummary{timeStamp='" + this.timeStamp.toString() + "', isOperational=" + this.isOperational + ", systemReadyState=" + this.systemReadyState + ", systemReadyStateErrorCause='" + this.systemReadyStateErrorCause + "', statusSummary=" + this.statusSummary + "}";
    }
}

