/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MBeanUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanUtils.class);

    private MBeanUtils() {
    }

    public static MBeanServer registerServerMBean(Object mxBeanImplementor, ObjectName objName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        LOG.debug("register MBean for {}", (Object)objName);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(mxBeanImplementor, objName);
            LOG.info("MBean registration for {} SUCCESSFUL.", (Object)objName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException ex) {
            LOG.error("MBean registration for {} FAILED.", (Object)objName, (Object)ex);
            throw ex;
        }
        return mbs;
    }

    public static MBeanServer registerServerMBean(Object mxBeanImplementor, String objNameStr) throws JMException {
        return MBeanUtils.registerServerMBean(mxBeanImplementor, ObjectName.getInstance(objNameStr));
    }

    public static void unregisterServerMBean(Object mxBeanImplementor, ObjectName objName) throws InstanceNotFoundException, MBeanRegistrationException {
        LOG.debug("unregister MXBean for {}", (Object)objName);
        MBeanServer mplatformMbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mplatformMbeanServer.unregisterMBean(objName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            LOG.error("Error while unregistering MBean {}", (Object)objName, (Object)e);
            throw e;
        }
    }

    public static void unregisterServerMBean(Object mxBeanImplementor, String objNameStr) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        MBeanUtils.unregisterServerMBean(mxBeanImplementor, ObjectName.getInstance(objNameStr));
    }

    public static @Nullable Object getMBeanAttribute(String objName, String attribute) throws JMException {
        return ManagementFactory.getPlatformMBeanServer().getAttribute(new ObjectName(objName), attribute);
    }

    private static <T> T getMBean(String jmxName, Class<T> klass, MBeanServerConnection mbsc) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(jmxName);
        return JMX.isMXBeanInterface(klass) ? JMX.newMXBeanProxy(mbsc, objectName, klass) : JMX.newMBeanProxy(mbsc, objectName, klass);
    }

    public static <T> T getMBean(String jmxName, Class<T> klass) throws MalformedObjectNameException {
        return MBeanUtils.getMBean(jmxName, klass, ManagementFactory.getPlatformMBeanServer());
    }

    static ObjectName objectNameOf(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

