/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.service.rev160307.send.ip.sgt.binding.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.service.rev160307.send.ip.sgt.binding.input.IpSgtBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.service.rev160307.send.ip.sgt.binding.input.IpSgtBindingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IpSgtBindingBuilder
implements Builder<IpSgtBinding> {
    private IpPrefix _ipPrefix;
    private IpSgtBindingKey _key;
    private Sgt _sgt;
    Map<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>> augmentation = Collections.emptyMap();

    public IpSgtBindingBuilder() {
    }

    public IpSgtBindingBuilder(IpSgtBinding base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new IpSgtBindingKey(base.getIpPrefix(), base.getSgt());
            this._ipPrefix = base.getIpPrefix();
            this._sgt = base.getSgt();
        } else {
            this._key = base.getKey();
            this._ipPrefix = this._key.getIpPrefix();
            this._sgt = this._key.getSgt();
        }
        if (base instanceof IpSgtBindingImpl) {
            IpSgtBindingImpl impl = (IpSgtBindingImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>>(casted.augmentations());
        }
    }

    public IpPrefix getIpPrefix() {
        return this._ipPrefix;
    }

    public IpSgtBindingKey getKey() {
        return this._key;
    }

    public Sgt getSgt() {
        return this._sgt;
    }

    public <E extends Augmentation<IpSgtBinding>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public IpSgtBindingBuilder setIpPrefix(IpPrefix value) {
        this._ipPrefix = value;
        return this;
    }

    public IpSgtBindingBuilder setKey(IpSgtBindingKey value) {
        this._key = value;
        return this;
    }

    public IpSgtBindingBuilder setSgt(Sgt value) {
        this._sgt = value;
        return this;
    }

    public IpSgtBindingBuilder addAugmentation(Class<? extends Augmentation<IpSgtBinding>> augmentationType, Augmentation<IpSgtBinding> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public IpSgtBindingBuilder removeAugmentation(Class<? extends Augmentation<IpSgtBinding>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IpSgtBinding build() {
        return new IpSgtBindingImpl(this);
    }

    private static final class IpSgtBindingImpl
    implements IpSgtBinding {
        private final IpPrefix _ipPrefix;
        private final IpSgtBindingKey _key;
        private final Sgt _sgt;
        private Map<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IpSgtBinding> getImplementedInterface() {
            return IpSgtBinding.class;
        }

        private IpSgtBindingImpl(IpSgtBindingBuilder base) {
            if (base.getKey() == null) {
                this._key = new IpSgtBindingKey(base.getIpPrefix(), base.getSgt());
                this._ipPrefix = base.getIpPrefix();
                this._sgt = base.getSgt();
            } else {
                this._key = base.getKey();
                this._ipPrefix = this._key.getIpPrefix();
                this._sgt = this._key.getSgt();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>>(base.augmentation);
                }
            }
        }

        @Override
        public IpPrefix getIpPrefix() {
            return this._ipPrefix;
        }

        @Override
        public IpSgtBindingKey getKey() {
            return this._key;
        }

        @Override
        public Sgt getSgt() {
            return this._sgt;
        }

        public <E extends Augmentation<IpSgtBinding>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipPrefix);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._sgt);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IpSgtBinding.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IpSgtBinding other = (IpSgtBinding)obj;
            if (!Objects.equals(this._ipPrefix, other.getIpPrefix())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._sgt, other.getSgt())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IpSgtBindingImpl otherImpl = (IpSgtBindingImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IpSgtBinding>>, Augmentation<IpSgtBinding>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("IpSgtBinding [");
            boolean first = true;
            if (this._ipPrefix != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipPrefix=");
                builder.append(this._ipPrefix);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._sgt != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sgt=");
                builder.append(this._sgt);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

