/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.listen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.DSAsyncDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.MasterDatabaseBindingListener;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SxpMapperReactor;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.EPTemplateUtil;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.L3EPServiceUtil;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SxpListenerUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointForwardingTemplateBySubnet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.SxpNodeIdentity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.network.topology.topology.node.SxpDomains;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.network.topology.topology.node.sxp.domains.SxpDomain;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.sxp.databases.fields.MasterDatabase;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterDatabaseBindingListenerImpl
implements MasterDatabaseBindingListener {
    private static final Logger LOG = LoggerFactory.getLogger(MasterDatabaseBindingListenerImpl.class);
    private static final FutureCallback<RpcResult<Void>> RPC_POLICY_RESULT_FUTURE_CALLBACK = L3EPServiceUtil.createFailureLoggingCallback("failed to read epPolicyTemplate");
    public static final FutureCallback<RpcResult<Void>> RPC_FW_RESULT_FUTURE_CALLBACK = L3EPServiceUtil.createFailureLoggingCallback("failed to read epForwardingTemplate");
    private final SxpMapperReactor sxpMapperReactor;
    private final SimpleCachedDao<IpPrefix, MasterDatabaseBinding> masterDBBindingDaoCached;
    private final DSAsyncDao<Sgt, EndpointPolicyTemplateBySgt> epPolicyTemplateDao;
    private final DSAsyncDao<IpPrefix, EndpointForwardingTemplateBySubnet> epForwardingTemplateDao;
    private final ListenerRegistration<? extends DataTreeChangeListener> listenerRegistration;
    private final InstanceIdentifier<MasterDatabaseBinding> sxpDbPath;

    public MasterDatabaseBindingListenerImpl(DataBroker dataBroker, SxpMapperReactor sxpMapperReactor, SimpleCachedDao<IpPrefix, MasterDatabaseBinding> masterDBBindingDaoCached, DSAsyncDao<Sgt, EndpointPolicyTemplateBySgt> epPolicyTemplateDao, DSAsyncDao<IpPrefix, EndpointForwardingTemplateBySubnet> epForwardingTemplateDao) {
        this.sxpMapperReactor = (SxpMapperReactor)Preconditions.checkNotNull((Object)sxpMapperReactor);
        this.masterDBBindingDaoCached = (SimpleCachedDao)Preconditions.checkNotNull(masterDBBindingDaoCached);
        this.epPolicyTemplateDao = (DSAsyncDao)Preconditions.checkNotNull(epPolicyTemplateDao);
        this.epForwardingTemplateDao = (DSAsyncDao)Preconditions.checkNotNull(epForwardingTemplateDao);
        this.sxpDbPath = MasterDatabaseBindingListener.SXP_TOPOLOGY_PATH.child(Node.class).augmentation(SxpNodeIdentity.class).child(SxpDomains.class).child(SxpDomain.class).child(MasterDatabase.class).child(MasterDatabaseBinding.class);
        DataTreeIdentifier dataTreeIdentifier = new DataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, this.sxpDbPath);
        this.listenerRegistration = dataBroker.registerDataTreeChangeListener(dataTreeIdentifier, (DataTreeChangeListener)this);
        LOG.debug("started listening to {}", this.sxpDbPath);
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<MasterDatabaseBinding>> collection) {
        for (DataTreeModification<MasterDatabaseBinding> change : collection) {
            LOG.trace("received modification: {} -> {}", (Object)change.getRootPath(), (Object)change.getRootNode().getModificationType());
            MasterDatabaseBinding sxpMasterDBItem = (MasterDatabaseBinding)change.getRootNode().getDataAfter();
            if (sxpMasterDBItem == null) {
                LOG.debug("ip-sgt mapping was removed - NOOP: {}", (Object)change.getRootPath().getRootIdentifier().firstKeyOf(MasterDatabaseBinding.class));
                continue;
            }
            IpPrefix ipPrefixKey = sxpMasterDBItem.getIpPrefix();
            SxpListenerUtil.updateCachedDao(this.masterDBBindingDaoCached, ipPrefixKey, change);
            this.processWithEPTemplates(sxpMasterDBItem);
        }
    }

    private void processWithEPTemplates(final MasterDatabaseBinding sxpMasterDBItem) {
        ListenableFuture<Optional<EndpointPolicyTemplateBySgt>> epPolicyTemplateFuture = this.epPolicyTemplateDao.read(sxpMasterDBItem.getSecurityGroupTag());
        ListenableFuture<Optional<EndpointForwardingTemplateBySubnet>> epForwardingTemplateFuture = this.epForwardingTemplateDao.read(sxpMasterDBItem.getIpPrefix());
        ListenableFuture<EPTemplateUtil.OptionalMutablePair<EndpointPolicyTemplateBySgt, EndpointForwardingTemplateBySubnet>> compositeRead = EPTemplateUtil.compositeRead(epPolicyTemplateFuture, epForwardingTemplateFuture);
        ListenableFuture rpcResult = Futures.transform(compositeRead, (AsyncFunction)new AsyncFunction<EPTemplateUtil.OptionalMutablePair<EndpointPolicyTemplateBySgt, EndpointForwardingTemplateBySubnet>, RpcResult<Void>>(){

            public ListenableFuture<RpcResult<Void>> apply(EPTemplateUtil.OptionalMutablePair<EndpointPolicyTemplateBySgt, EndpointForwardingTemplateBySubnet> input) throws Exception {
                ListenableFuture<RpcResult<Void>> result;
                if (input == null) {
                    LOG.debug("no ep*Templates available for sgt/ip-prefix: {}/{}", (Object)sxpMasterDBItem.getSecurityGroupTag(), (Object)sxpMasterDBItem.getIpPrefix());
                    result = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "no ep-templates available for" + sxpMasterDBItem).buildFuture();
                } else if (!((Optional)input.getLeft()).isPresent()) {
                    LOG.debug("no epPolicyTemplate available for sgt: {}", (Object)sxpMasterDBItem.getSecurityGroupTag());
                    result = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "no epPolicyTemplate available for " + sxpMasterDBItem).buildFuture();
                } else if (!((Optional)input.getRight()).isPresent()) {
                    LOG.debug("no epForwardingTemplate available for ip-prefix: {}", (Object)sxpMasterDBItem.getIpPrefix());
                    result = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "no epForwardingTemplate available for " + sxpMasterDBItem).buildFuture();
                } else {
                    LOG.trace("processing sxpMasterDB event and epPolicyTemplate for sgt/ip-prefix: {}/{}", (Object)sxpMasterDBItem.getSecurityGroupTag(), (Object)sxpMasterDBItem.getIpPrefix());
                    result = MasterDatabaseBindingListenerImpl.this.sxpMapperReactor.processTemplatesAndSxpMasterDB((EndpointPolicyTemplateBySgt)((Optional)input.getLeft()).get(), (EndpointForwardingTemplateBySubnet)((Optional)input.getRight()).get(), sxpMasterDBItem);
                }
                return result;
            }
        });
        Futures.addCallback((ListenableFuture)rpcResult, RPC_POLICY_RESULT_FUTURE_CALLBACK);
    }

    @Override
    public void close() throws Exception {
        LOG.debug("closing listener registration to {}", this.sxpDbPath);
        this.listenerRegistration.close();
    }
}

