/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao;

import com.google.common.base.Function;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.DSAsyncDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.MasterDatabaseBindingListener;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.ReadableAsyncByKey;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SxpListenerUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.MasterDatabaseFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.SxpDatabasesFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.SxpNodeIdentity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.node.rev160308.network.topology.topology.node.SxpDomains;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterDatabaseBindingDaoImpl
implements DSAsyncDao<IpPrefix, MasterDatabaseBinding>,
ReadableAsyncByKey<Sgt, MasterDatabaseBinding> {
    private static final Logger LOG = LoggerFactory.getLogger(MasterDatabaseBindingDaoImpl.class);
    private static final ListenableFuture<com.google.common.base.Optional<MasterDatabaseBinding>> READ_FUTURE_ABSENT = Futures.immediateFuture((Object)com.google.common.base.Optional.absent());
    private final DataBroker dataBroker;
    private final SimpleCachedDao<IpPrefix, MasterDatabaseBinding> cachedDao;

    public MasterDatabaseBindingDaoImpl(DataBroker dataBroker, SimpleCachedDao<IpPrefix, MasterDatabaseBinding> cachedDao) {
        this.dataBroker = dataBroker;
        this.cachedDao = cachedDao;
    }

    @Override
    public ListenableFuture<com.google.common.base.Optional<MasterDatabaseBinding>> read(final @Nonnull IpPrefix key) {
        com.google.common.base.Optional<MasterDatabaseBinding> cachedMasterDatabaseBinding = this.lookup(this.cachedDao, key);
        if (cachedMasterDatabaseBinding.isPresent()) {
            return Futures.immediateFuture(cachedMasterDatabaseBinding);
        }
        if (!this.cachedDao.isEmpty()) {
            return READ_FUTURE_ABSENT;
        }
        ListenableFuture<Void> cacheUpdatedFt = this.updateCache();
        return Futures.transform(cacheUpdatedFt, (Function)new Function<Void, com.google.common.base.Optional<MasterDatabaseBinding>>(){

            @Nullable
            public com.google.common.base.Optional<MasterDatabaseBinding> apply(@Nullable Void input) {
                return MasterDatabaseBindingDaoImpl.this.lookup(MasterDatabaseBindingDaoImpl.this.cachedDao, key);
            }
        });
    }

    private ListenableFuture<Void> updateCache() {
        ReadOnlyTransaction rTx = this.dataBroker.newReadOnlyTransaction();
        CheckedFuture read = rTx.read(LogicalDatastoreType.CONFIGURATION, this.buildReadPath(null));
        Futures.addCallback((ListenableFuture)read, SxpListenerUtil.createTxCloseCallback(rTx));
        return Futures.transform((ListenableFuture)read, (Function)new Function<com.google.common.base.Optional<Topology>, Void>(){

            @Nullable
            public Void apply(@Nullable com.google.common.base.Optional<Topology> input) {
                if (input.isPresent()) {
                    MasterDatabaseBindingDaoImpl.this.cachedDao.invalidateCache();
                    for (Node node : ((Topology)input.get()).getNode()) {
                        Optional.ofNullable(node.getAugmentation(SxpNodeIdentity.class)).map(SxpNodeIdentity::getSxpDomains).map(SxpDomains::getSxpDomain).ifPresent(sxpDomain -> {
                            List masterDBBindings = sxpDomain.stream().map(SxpDatabasesFields::getMasterDatabase).filter(masterDb -> masterDb != null).map(MasterDatabaseFields::getMasterDatabaseBinding).filter(binding -> binding != null).flatMap(Collection::stream).collect(Collectors.toList());
                            for (MasterDatabaseBinding masterDBItem : masterDBBindings) {
                                MasterDatabaseBinding previousValue = MasterDatabaseBindingDaoImpl.this.cachedDao.update(masterDBItem.getIpPrefix(), masterDBItem);
                                if (previousValue == null) continue;
                                LOG.warn("updated key already obtained: [node:{}, sgt:{}]", (Object)node.getNodeId().getValue(), (Object)masterDBItem.getSecurityGroupTag());
                            }
                        });
                    }
                } else {
                    LOG.warn("failed to update cache of SxpMasterDB - no data");
                }
                return null;
            }
        });
    }

    private InstanceIdentifier<Topology> buildReadPath(Sgt key) {
        return MasterDatabaseBindingListener.SXP_TOPOLOGY_PATH;
    }

    private com.google.common.base.Optional<MasterDatabaseBinding> lookup(SimpleCachedDao<IpPrefix, MasterDatabaseBinding> cachedDao, IpPrefix key) {
        return cachedDao.find(key);
    }

    @Override
    public ListenableFuture<Collection<MasterDatabaseBinding>> readBy(final @Nonnull Sgt specialKey) {
        ListenableFuture<Void> cacheUpdatedFt = !this.cachedDao.isEmpty() ? Futures.immediateFuture(null) : this.updateCache();
        return Futures.transform(cacheUpdatedFt, (Function)new Function<Void, Collection<MasterDatabaseBinding>>(){

            @Nullable
            public Collection<MasterDatabaseBinding> apply(@Nullable Void input) {
                ArrayList<MasterDatabaseBinding> foundGroups = new ArrayList<MasterDatabaseBinding>();
                for (MasterDatabaseBinding masterDBItem : MasterDatabaseBindingDaoImpl.this.cachedDao.values()) {
                    if (!masterDBItem.getSecurityGroupTag().equals((Object)specialKey)) continue;
                    foundGroups.add(masterDBItem);
                }
                return foundGroups;
            }
        });
    }
}

