/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.DSAsyncDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.EPTemplateListener;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.ReadableByKey;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EpPolicyTemplateValueKey;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EpPolicyTemplateValueKeyFactory;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SxpListenerUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgtKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class EPPolicyTemplateDaoImpl
implements DSAsyncDao<Sgt, EndpointPolicyTemplateBySgt>,
ReadableByKey<EpPolicyTemplateValueKey, EndpointPolicyTemplateBySgt> {
    private static final ListenableFuture<Optional<EndpointPolicyTemplateBySgt>> READ_FUTURE_ABSENT = Futures.immediateFuture((Object)Optional.absent());
    private final DataBroker dataBroker;
    private final SimpleCachedDao<Sgt, EndpointPolicyTemplateBySgt> cachedDao;
    private final EpPolicyTemplateValueKeyFactory keyFactory;

    public EPPolicyTemplateDaoImpl(DataBroker dataBroker, SimpleCachedDao<Sgt, EndpointPolicyTemplateBySgt> cachedDao, EpPolicyTemplateValueKeyFactory keyFactory) {
        this.dataBroker = dataBroker;
        this.cachedDao = cachedDao;
        this.keyFactory = keyFactory;
    }

    @Override
    public ListenableFuture<Optional<EndpointPolicyTemplateBySgt>> read(final @Nonnull Sgt key) {
        Optional<EndpointPolicyTemplateBySgt> cachedEndpointPolicyTemplateBySgtalue = this.lookup(this.cachedDao, key);
        if (cachedEndpointPolicyTemplateBySgtalue.isPresent()) {
            return Futures.immediateFuture(cachedEndpointPolicyTemplateBySgtalue);
        }
        if (!this.cachedDao.isEmpty()) {
            return READ_FUTURE_ABSENT;
        }
        ReadOnlyTransaction rTx = this.dataBroker.newReadOnlyTransaction();
        CheckedFuture read = rTx.read(LogicalDatastoreType.CONFIGURATION, this.buildReadPath(key));
        Futures.addCallback((ListenableFuture)read, SxpListenerUtil.createTxCloseCallback(rTx));
        return Futures.transform((ListenableFuture)read, (Function)new Function<Optional<EndpointPolicyTemplateBySgt>, Optional<EndpointPolicyTemplateBySgt>>(){

            @Nullable
            public Optional<EndpointPolicyTemplateBySgt> apply(@Nullable Optional<EndpointPolicyTemplateBySgt> input) {
                if (input.isPresent()) {
                    EPPolicyTemplateDaoImpl.this.cachedDao.update(key, EPPolicyTemplateDaoImpl.this.keyFactory.sortValueKeyLists((EndpointPolicyTemplateBySgt)input.get()));
                }
                return input;
            }
        });
    }

    protected InstanceIdentifier<EndpointPolicyTemplateBySgt> buildReadPath(Sgt key) {
        return EPTemplateListener.SXP_MAPPER_TEMPLATE_PARENT_PATH.child(EndpointPolicyTemplateBySgt.class, (Identifier)new EndpointPolicyTemplateBySgtKey(key));
    }

    private Optional<EndpointPolicyTemplateBySgt> lookup(SimpleCachedDao<Sgt, EndpointPolicyTemplateBySgt> cachedDao, Sgt key) {
        return cachedDao.find(key);
    }

    @Override
    public Collection<EndpointPolicyTemplateBySgt> readBy(@Nonnull EpPolicyTemplateValueKey specialKey) {
        Predicate templateValuePredicate = Predicates.equalTo((Object)specialKey);
        ArrayList<EndpointPolicyTemplateBySgt> foundTemplates = new ArrayList<EndpointPolicyTemplateBySgt>();
        for (EndpointPolicyTemplateBySgt epPolicyTemplate : this.cachedDao.values()) {
            EpPolicyTemplateValueKey templateValueKey = this.keyFactory.createKeyWithDefaultOrdering(epPolicyTemplate);
            if (!templateValuePredicate.apply((Object)templateValueKey)) continue;
            foundTemplates.add(epPolicyTemplate);
        }
        return foundTemplates;
    }
}

