/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.DSAsyncDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.EPTemplateListener;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SimpleCachedDao;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SxpListenerUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.SxpMapper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointForwardingTemplateBySubnet;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class EPForwardingTemplateDaoImpl
implements DSAsyncDao<IpPrefix, EndpointForwardingTemplateBySubnet> {
    private static final ListenableFuture<Optional<EndpointForwardingTemplateBySubnet>> READ_FUTURE_ABSENT = Futures.immediateFuture((Object)Optional.absent());
    private final DataBroker dataBroker;
    private final SimpleCachedDao<IpPrefix, EndpointForwardingTemplateBySubnet> cachedDao;

    public EPForwardingTemplateDaoImpl(DataBroker dataBroker, SimpleCachedDao<IpPrefix, EndpointForwardingTemplateBySubnet> cachedDao) {
        this.dataBroker = dataBroker;
        this.cachedDao = cachedDao;
    }

    @Override
    public ListenableFuture<Optional<EndpointForwardingTemplateBySubnet>> read(final @Nonnull IpPrefix key) {
        ListenableFuture readResult;
        Optional<EndpointForwardingTemplateBySubnet> value = this.lookup(this.cachedDao, key);
        if (value.isPresent()) {
            readResult = Futures.immediateFuture(value);
        } else {
            if (!this.cachedDao.isEmpty()) {
                return READ_FUTURE_ABSENT;
            }
            ReadOnlyTransaction rTx = this.dataBroker.newReadOnlyTransaction();
            CheckedFuture read = rTx.read(LogicalDatastoreType.CONFIGURATION, this.buildReadPath(key));
            Futures.addCallback((ListenableFuture)read, SxpListenerUtil.createTxCloseCallback(rTx));
            readResult = Futures.transform((ListenableFuture)read, (Function)new Function<Optional<SxpMapper>, Optional<EndpointForwardingTemplateBySubnet>>(){

                @Nullable
                public Optional<EndpointForwardingTemplateBySubnet> apply(@Nullable Optional<SxpMapper> input) {
                    if (input.isPresent()) {
                        EPForwardingTemplateDaoImpl.this.cachedDao.invalidateCache();
                        List<EndpointForwardingTemplateBySubnet> templateLot = ((SxpMapper)input.get()).getEndpointForwardingTemplateBySubnet();
                        if (templateLot != null) {
                            for (EndpointForwardingTemplateBySubnet template : templateLot) {
                                EPForwardingTemplateDaoImpl.this.cachedDao.update(template.getIpPrefix(), template);
                            }
                        }
                        return EPForwardingTemplateDaoImpl.this.lookup(EPForwardingTemplateDaoImpl.this.cachedDao, key);
                    }
                    return Optional.absent();
                }
            });
        }
        return readResult;
    }

    protected InstanceIdentifier<SxpMapper> buildReadPath(IpPrefix key) {
        return EPTemplateListener.SXP_MAPPER_TEMPLATE_PARENT_PATH;
    }

    private Optional<EndpointForwardingTemplateBySubnet> lookup(SimpleCachedDao<IpPrefix, EndpointForwardingTemplateBySubnet> cachedDao, IpPrefix key) {
        return cachedDao.find(key);
    }
}

