/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SxpMapperReactor;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.SxpListenerUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.BaseEndpointService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.Endpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.RegisterEndpointInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.RegisterEndpointInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.common.endpoint.fields.NetworkContainment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.common.endpoint.fields.NetworkContainmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.common.endpoint.fields.network.containment.Containment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.common.endpoint.fields.network.containment.containment.NetworkDomainContainmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.endpoints.AddressEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.endpoints.address.endpoints.AddressEndpoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.endpoints.address.endpoints.AddressEndpointKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.register.endpoint.input.AddressEndpointReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.register.endpoint.input.AddressEndpointRegBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.common.rev140421.ContextId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.common.rev140421.EndpointGroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.forwarding.l2_l3.rev160427.IpPrefixType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.forwarding.l2_l3.rev160427.L3Context;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointForwardingTemplateBySubnet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBinding;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SxpMapperReactorImpl
implements SxpMapperReactor {
    private static final Logger LOG = LoggerFactory.getLogger(SxpMapperReactorImpl.class);
    private final BaseEndpointService l3EndpointService;
    private final DataBroker dataBroker;

    public SxpMapperReactorImpl(BaseEndpointService l3EndpointService, DataBroker dataBroker) {
        this.l3EndpointService = (BaseEndpointService)Preconditions.checkNotNull((Object)l3EndpointService, (Object)"l3Endpoint service missing");
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker, (Object)"dataBroker missing");
    }

    @Override
    public ListenableFuture<RpcResult<Void>> processTemplatesAndSxpMasterDB(EndpointPolicyTemplateBySgt epPolicyTemplate, EndpointForwardingTemplateBySubnet epForwardingTemplate, MasterDatabaseBinding masterDBBinding) {
        LOG.debug("processing ep-templates + sxpMasterDB entry: {} - {}", (Object)masterDBBinding.getSecurityGroupTag(), (Object)masterDBBinding.getIpPrefix());
        Ipv4Prefix address = new Ipv4Prefix(epForwardingTemplate.getIpPrefix().getIpv4Prefix().getValue());
        NetworkContainment networkContainment = new NetworkContainmentBuilder().setContainment((Containment)new NetworkDomainContainmentBuilder().setNetworkDomainType(epForwardingTemplate.getNetworkContainment().getNetworkDomainType()).setNetworkDomainId(epForwardingTemplate.getNetworkContainment().getNetworkDomainId()).build()).build();
        RegisterEndpointInput epInput = new RegisterEndpointInputBuilder().setAddressEndpointReg(Collections.singletonList(new AddressEndpointRegBuilder().setAddressType(IpPrefixType.class).setAddress(address.getValue()).setContextType(L3Context.class).setContextId(epForwardingTemplate.getL3Context()).setNetworkContainment(networkContainment).setCondition(epPolicyTemplate.getConditions()).setTenant(epPolicyTemplate.getTenant()).setEndpointGroup(epPolicyTemplate.getEndpointGroups()).build())).build();
        epForwardingTemplate.getL3Context();
        return this.chainL3EPServiceIfEpAbsent(epInput);
    }

    private CheckedFuture<Optional<AddressEndpoint>, ReadFailedException> findExistingEndPoint(ContextId containment, String address) {
        KeyedInstanceIdentifier addressEndpointPath = InstanceIdentifier.create(Endpoints.class).child(AddressEndpoints.class).child(AddressEndpoint.class, (Identifier)new AddressEndpointKey(address, IpPrefixType.class, containment, L3Context.class));
        ReadOnlyTransaction rTx = this.dataBroker.newReadOnlyTransaction();
        CheckedFuture read = rTx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)addressEndpointPath);
        Futures.addCallback((ListenableFuture)read, SxpListenerUtil.createTxCloseCallback(rTx));
        return read;
    }

    private ListenableFuture<RpcResult<Void>> chainL3EPServiceIfEpAbsent(final RegisterEndpointInput epInput) {
        final AddressEndpointReg addressEndpoint = (AddressEndpointReg)epInput.getAddressEndpointReg().get(0);
        CheckedFuture<Optional<AddressEndpoint>, ReadFailedException> existingEndpointFuture = this.findExistingEndPoint(addressEndpoint.getContextId(), addressEndpoint.getAddress());
        return Futures.transform(existingEndpointFuture, (AsyncFunction)new AsyncFunction<Optional<AddressEndpoint>, RpcResult<Void>>(){

            public ListenableFuture<RpcResult<Void>> apply(Optional<AddressEndpoint> input) throws Exception {
                if (input == null || !input.isPresent() || !SxpMapperReactorImpl.this.isSameEpg(epInput, (AddressEndpoint)input.get())) {
                    return JdkFutureAdapters.listenInPoolThread((Future)SxpMapperReactorImpl.this.l3EndpointService.registerEndpoint(epInput));
                }
                String existingL3EpMsg = String.format("address-endpoint for given key already exists: %s | %s", addressEndpoint.getContextId(), addressEndpoint.getAddress());
                ListenableFuture nextResult = Futures.immediateFailedFuture((Throwable)new IllegalStateException(existingL3EpMsg));
                return nextResult;
            }
        });
    }

    private boolean isSameEpg(RegisterEndpointInput epInput, AddressEndpoint input) {
        if (epInput == null || epInput.getAddressEndpointReg() == null || epInput.getAddressEndpointReg().isEmpty()) {
            return true;
        }
        AddressEndpointReg epInputAddressEndpoint = (AddressEndpointReg)epInput.getAddressEndpointReg().get(0);
        if (epInputAddressEndpoint.getEndpointGroup() == null || epInputAddressEndpoint.getEndpointGroup().isEmpty()) {
            return true;
        }
        if (input == null || input.getEndpointGroup() == null || input.getEndpointGroup().isEmpty()) {
            return true;
        }
        EndpointGroupId addressEndpointGroupId = (EndpointGroupId)epInputAddressEndpoint.getEndpointGroup().get(0);
        EndpointGroupId existingEndpointGroupId = (EndpointGroupId)input.getEndpointGroup().get(0);
        return addressEndpointGroupId.equals((Object)existingEndpointGroupId);
    }
}

