/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl;

import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.groupbasedpolicy.api.DomainSpecificRegistry;
import org.opendaylight.groupbasedpolicy.api.EndpointAugmentor;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.EPTemplateListener;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.SxpMapperReactor;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.SxpEndpointAugmentorImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.SxpMapperReactorImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EPForwardingTemplateDaoImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EPPolicyTemplateDaoImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EpPolicyTemplateValueKeyFactory;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.MasterDatabaseBindingDaoImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.SimpleCachedDaoEPForwardingTemplateImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.SimpleCachedDaoImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.listen.EPForwardingTemplateListenerImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.listen.EPPolicyTemplateListenerImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.listen.MasterDatabaseBindingListenerImpl;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.util.EPTemplateUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.BaseEndpointService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.Sgt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.sxp.database.rev160308.master.database.fields.MasterDatabaseBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SxpMapperProviderImpl
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SxpMapperProviderImpl.class);
    private final MasterDatabaseBindingListenerImpl sxpDatabaseListener;
    private final SxpMapperReactor sxpMapperReactor;
    private final EPTemplateListener epPolicyTemplateListener;
    private final EPTemplateListener epForwardingTemplateListener;
    private final DomainSpecificRegistry domainSpecificRegistry;
    private final EndpointAugmentor sxpEndpointAugmentor;

    public SxpMapperProviderImpl(DataBroker dataBroker, BaseEndpointService endpointService, DomainSpecificRegistry domainSpecificRegistry) {
        LOG.info("starting SxmMapper ..");
        this.domainSpecificRegistry = domainSpecificRegistry;
        this.sxpMapperReactor = new SxpMapperReactorImpl(endpointService, dataBroker);
        SimpleCachedDaoImpl<Sgt, EndpointPolicyTemplateBySgt> epPolicyTemplateCachedDao = new SimpleCachedDaoImpl<Sgt, EndpointPolicyTemplateBySgt>();
        SimpleCachedDaoEPForwardingTemplateImpl epForwardingTemplateCachedDao = new SimpleCachedDaoEPForwardingTemplateImpl();
        SimpleCachedDaoImpl<IpPrefix, MasterDatabaseBinding> masterDBBindingCachedDao = new SimpleCachedDaoImpl<IpPrefix, MasterDatabaseBinding>();
        EpPolicyTemplateValueKeyFactory epPolicyTemplateKeyFactory = new EpPolicyTemplateValueKeyFactory(EPTemplateUtil.createEndpointGroupIdOrdering(), EPTemplateUtil.createConditionNameOrdering());
        EPPolicyTemplateDaoImpl epPolicyTemplateDao = new EPPolicyTemplateDaoImpl(dataBroker, epPolicyTemplateCachedDao, epPolicyTemplateKeyFactory);
        EPForwardingTemplateDaoImpl epForwardingTemplateDao = new EPForwardingTemplateDaoImpl(dataBroker, epForwardingTemplateCachedDao);
        MasterDatabaseBindingDaoImpl masterDBBindingDao = new MasterDatabaseBindingDaoImpl(dataBroker, masterDBBindingCachedDao);
        this.sxpDatabaseListener = new MasterDatabaseBindingListenerImpl(dataBroker, this.sxpMapperReactor, masterDBBindingCachedDao, epPolicyTemplateDao, epForwardingTemplateDao);
        this.epPolicyTemplateListener = new EPPolicyTemplateListenerImpl(dataBroker, this.sxpMapperReactor, epPolicyTemplateCachedDao, masterDBBindingDao, epForwardingTemplateDao);
        this.epForwardingTemplateListener = new EPForwardingTemplateListenerImpl(dataBroker, this.sxpMapperReactor, epForwardingTemplateCachedDao, masterDBBindingDao, epPolicyTemplateDao);
        this.sxpEndpointAugmentor = new SxpEndpointAugmentorImpl(epPolicyTemplateDao, epPolicyTemplateKeyFactory);
        domainSpecificRegistry.getEndpointAugmentorRegistry().register(this.sxpEndpointAugmentor);
        LOG.info("started SxmMapper");
    }

    @Override
    public void close() throws Exception {
        this.sxpDatabaseListener.close();
        this.epPolicyTemplateListener.close();
        this.epForwardingTemplateListener.close();
        this.domainSpecificRegistry.getEndpointAugmentorRegistry().unregister(this.sxpEndpointAugmentor);
    }
}

