/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.groupbasedpolicy.sxp.mapper.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import org.opendaylight.groupbasedpolicy.api.EndpointAugmentor;
import org.opendaylight.groupbasedpolicy.sxp.mapper.api.ReadableByKey;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EpPolicyTemplateValueKey;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.dao.EpPolicyTemplateValueKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.endpoints.address.endpoints.AddressEndpoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.endpoints.containment.endpoints.ContainmentEndpoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.register.endpoint.input.AddressEndpointReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.register.endpoint.input.ContainmentEndpointReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.renderer.rev151103.renderers.renderer.renderer.policy.configuration.endpoints.AddressEndpointWithLocation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.renderer.rev151103.renderers.renderer.renderer.policy.configuration.endpoints.ContainmentEndpointWithLocation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.AddressEndpointWithLocationAug;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.AddressEndpointWithLocationAugBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.groupbasedpolicy.sxp.mapper.model.rev160302.sxp.mapper.EndpointPolicyTemplateBySgt;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SxpEndpointAugmentorImpl
implements EndpointAugmentor {
    private final ReadableByKey<EpPolicyTemplateValueKey, EndpointPolicyTemplateBySgt> epPolicyTemplateDao;
    private final EpPolicyTemplateValueKeyFactory epPolicyTemplateKeyFactory;

    public SxpEndpointAugmentorImpl(ReadableByKey<EpPolicyTemplateValueKey, EndpointPolicyTemplateBySgt> epPolicyTemplateDao, EpPolicyTemplateValueKeyFactory epPolicyTemplateKeyFactory) {
        this.epPolicyTemplateKeyFactory = (EpPolicyTemplateValueKeyFactory)Preconditions.checkNotNull((Object)epPolicyTemplateKeyFactory, (Object)"epPolicyTemplateKeyFactory can not be null");
        this.epPolicyTemplateDao = (ReadableByKey)Preconditions.checkNotNull(epPolicyTemplateDao, (Object)"epPolicyTemplateDao can not be null");
    }

    public Map.Entry<Class<? extends Augmentation<AddressEndpoint>>, Augmentation<AddressEndpoint>> buildAddressEndpointAugmentation(AddressEndpointReg input) {
        return null;
    }

    public Map.Entry<Class<? extends Augmentation<ContainmentEndpoint>>, Augmentation<ContainmentEndpoint>> buildContainmentEndpointAugmentation(ContainmentEndpointReg input) {
        return null;
    }

    public Map.Entry<Class<? extends Augmentation<AddressEndpointWithLocation>>, Augmentation<AddressEndpointWithLocation>> buildAddressEndpointWithLocationAugmentation(AddressEndpoint input) {
        AbstractMap.SimpleEntry<Class<AddressEndpointWithLocationAug>, AddressEndpointWithLocationAug> entry;
        EpPolicyTemplateValueKey templateValueKey = this.epPolicyTemplateKeyFactory.createKey(input.getTenant(), input.getEndpointGroup(), input.getCondition());
        Collection<EndpointPolicyTemplateBySgt> epPolicyTemplates = this.epPolicyTemplateDao.readBy(templateValueKey);
        if (epPolicyTemplates.isEmpty()) {
            entry = null;
        } else {
            AddressEndpointWithLocationAug addressEndpointWithLocationAug = new AddressEndpointWithLocationAugBuilder().setSgt(((EndpointPolicyTemplateBySgt)Iterables.getFirst(epPolicyTemplates, null)).getSgt()).build();
            entry = new AbstractMap.SimpleEntry<Class<AddressEndpointWithLocationAug>, AddressEndpointWithLocationAug>(AddressEndpointWithLocationAug.class, addressEndpointWithLocationAug);
        }
        return entry;
    }

    public Map.Entry<Class<? extends Augmentation<ContainmentEndpointWithLocation>>, Augmentation<ContainmentEndpointWithLocation>> buildContainmentEndpointWithLocationAugmentation(ContainmentEndpoint input) {
        return null;
    }
}

