/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.groupbasedpolicy.sxp_mapper;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.groupbasedpolicy.api.DomainSpecificRegistry;
import org.opendaylight.groupbasedpolicy.sxp.mapper.impl.SxpMapperProviderImpl;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groupbasedpolicy.base_endpoint.rev160427.BaseEndpointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SxpMapperProviderInstance
implements ClusterSingletonService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SxpMapperProviderInstance.class);
    private static final ServiceGroupIdentifier IDENTIFIER = ServiceGroupIdentifier.create((String)"gbp-service-group-identifier");
    private final DataBroker dataBroker;
    private final BaseEndpointService endpointService;
    private final DomainSpecificRegistry registry;
    private final ClusterSingletonServiceProvider clusterSingletonService;
    private ClusterSingletonServiceRegistration singletonServiceRegistration;
    private SxpMapperProviderImpl sxpMapperProviderImpl;

    public SxpMapperProviderInstance(DataBroker dataBroker, BaseEndpointService endpointService, DomainSpecificRegistry registry, ClusterSingletonServiceProvider clusterSingletonService) {
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker);
        this.endpointService = (BaseEndpointService)Preconditions.checkNotNull((Object)endpointService);
        this.registry = (DomainSpecificRegistry)Preconditions.checkNotNull((Object)registry);
        this.clusterSingletonService = (ClusterSingletonServiceProvider)Preconditions.checkNotNull((Object)clusterSingletonService);
    }

    public void initialize() {
        LOG.info("Clustering session initiated for {}", (Object)this.getClass().getSimpleName());
        this.singletonServiceRegistration = this.clusterSingletonService.registerClusterSingletonService((ClusterSingletonService)this);
    }

    public void instantiateServiceInstance() {
        LOG.info("Instantiating {}", (Object)this.getClass().getSimpleName());
        this.sxpMapperProviderImpl = new SxpMapperProviderImpl(this.dataBroker, this.endpointService, this.registry);
    }

    public ListenableFuture<Void> closeServiceInstance() {
        LOG.info("Instance {} closed", (Object)this.getClass().getSimpleName());
        try {
            this.sxpMapperProviderImpl.close();
        }
        catch (Exception e) {
            LOG.warn("Exception while closing ... {}", (Object)e.getMessage());
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public void close() throws Exception {
        LOG.info("Clustering provider closed for {}", (Object)this.getClass().getSimpleName());
        if (this.singletonServiceRegistration != null) {
            try {
                this.singletonServiceRegistration.close();
            }
            catch (Exception e) {
                LOG.warn("{} closed unexpectedly. Cause: {}", (Object)e.getMessage());
            }
            this.singletonServiceRegistration = null;
        }
    }

    public ServiceGroupIdentifier getIdentifier() {
        return IDENTIFIER;
    }
}

