/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.service.bindings;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.ServiceModeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.service.bindings.ServicesInfo;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.service.bindings.ServicesInfoKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.service.bindings.services.info.BoundServices;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServicesInfoBuilder
implements Builder<ServicesInfo> {
    private List<BoundServices> _boundServices;
    private String _interfaceName;
    private ServicesInfoKey _key;
    private Class<? extends ServiceModeBase> _serviceMode;
    Map<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>> augmentation = Collections.emptyMap();

    public ServicesInfoBuilder() {
    }

    public ServicesInfoBuilder(ServicesInfo base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServicesInfoKey(base.getInterfaceName(), base.getServiceMode());
            this._interfaceName = base.getInterfaceName();
            this._serviceMode = base.getServiceMode();
        } else {
            this._key = base.getKey();
            this._interfaceName = this._key.getInterfaceName();
            this._serviceMode = this._key.getServiceMode();
        }
        this._boundServices = base.getBoundServices();
        if (base instanceof ServicesInfoImpl) {
            ServicesInfoImpl impl = (ServicesInfoImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>>(casted.augmentations());
        }
    }

    public List<BoundServices> getBoundServices() {
        return this._boundServices;
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public ServicesInfoKey getKey() {
        return this._key;
    }

    public Class<? extends ServiceModeBase> getServiceMode() {
        return this._serviceMode;
    }

    public <E extends Augmentation<ServicesInfo>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServicesInfoBuilder setBoundServices(List<BoundServices> value) {
        this._boundServices = value;
        return this;
    }

    public ServicesInfoBuilder setInterfaceName(String value) {
        this._interfaceName = value;
        return this;
    }

    public ServicesInfoBuilder setKey(ServicesInfoKey value) {
        this._key = value;
        return this;
    }

    public ServicesInfoBuilder setServiceMode(Class<? extends ServiceModeBase> value) {
        this._serviceMode = value;
        return this;
    }

    public ServicesInfoBuilder addAugmentation(Class<? extends Augmentation<ServicesInfo>> augmentationType, Augmentation<ServicesInfo> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServicesInfoBuilder removeAugmentation(Class<? extends Augmentation<ServicesInfo>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServicesInfo build() {
        return new ServicesInfoImpl(this);
    }

    private static final class ServicesInfoImpl
    implements ServicesInfo {
        private final List<BoundServices> _boundServices;
        private final String _interfaceName;
        private final ServicesInfoKey _key;
        private final Class<? extends ServiceModeBase> _serviceMode;
        private Map<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServicesInfo> getImplementedInterface() {
            return ServicesInfo.class;
        }

        private ServicesInfoImpl(ServicesInfoBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServicesInfoKey(base.getInterfaceName(), base.getServiceMode());
                this._interfaceName = base.getInterfaceName();
                this._serviceMode = base.getServiceMode();
            } else {
                this._key = base.getKey();
                this._interfaceName = this._key.getInterfaceName();
                this._serviceMode = this._key.getServiceMode();
            }
            this._boundServices = base.getBoundServices();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BoundServices> getBoundServices() {
            return this._boundServices;
        }

        @Override
        public String getInterfaceName() {
            return this._interfaceName;
        }

        @Override
        public ServicesInfoKey getKey() {
            return this._key;
        }

        @Override
        public Class<? extends ServiceModeBase> getServiceMode() {
            return this._serviceMode;
        }

        public <E extends Augmentation<ServicesInfo>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._boundServices);
            result = 31 * result + Objects.hashCode(this._interfaceName);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._serviceMode);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServicesInfo.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServicesInfo other = (ServicesInfo)obj;
            if (!Objects.equals(this._boundServices, other.getBoundServices())) {
                return false;
            }
            if (!Objects.equals(this._interfaceName, other.getInterfaceName())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._serviceMode, other.getServiceMode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServicesInfoImpl otherImpl = (ServicesInfoImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServicesInfo>>, Augmentation<ServicesInfo>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServicesInfo [";
            StringBuilder builder = new StringBuilder(name);
            if (this._boundServices != null) {
                builder.append("_boundServices=");
                builder.append(this._boundServices);
                builder.append(", ");
            }
            if (this._interfaceName != null) {
                builder.append("_interfaceName=");
                builder.append(this._interfaceName);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._serviceMode != null) {
                builder.append("_serviceMode=");
                builder.append(this._serviceMode);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

